/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/05/25, 10:47
!  AUTHOR(S): KOGA, Junichiro
!  File : SftpNode.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.ssh.sftp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.filebrowser.DefaultFileBrowserNode;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;

/**
 * a tree node for the sftp client
 * 
 * @author KOGA, Junichiro
 */

public class SftpNode extends DefaultFileBrowserNode {
    private static Logger logger = Logger.getLogger(SftpNode.class.getName());

    private int mode = 0;
    private MyJMenuItem transfer;

    public SftpNode(Object userObject) {
        super(userObject);
        if (userObject instanceof RemoteFile) {
            RemoteFile uo = (RemoteFile) userObject;
            if (uo.isRemote()) {
                mode = SftpClientPanel.REMOTE_PANE;
            } else {
                mode = SftpClientPanel.LOCAL_PANE;
            }
        }
    }

    protected void showMenu(MouseEvent e) {
        if (e == null) {
            logger.error("MouseEvent is null");
            return;
        }

        JPopupMenu popup = new JPopupMenu();
        MyJMenuItem[] items;

        items = getDefaultMenuItems();

        String transfer_mode = "download";
        if (mode == SftpClientPanel.LOCAL_PANE) {
            transfer_mode = "upload";
        }

        transfer = new MyJMenuItem(transfer_mode);
        popup.add(transfer);
        popup.addSeparator();

        for (int i = 0; i < items.length; i++) {
            popup.add(items[i]);
        }
        popup.addPopupMenuListener(new PopupMenuListener() {
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                transfer.setEnabled(tree.isConnected());
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
        });

        if (e.getComponent() == null) {
            logger.error("e.getComponent() returns null...something is wrong!");
            return;
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
        transfer.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (mode == SftpClientPanel.LOCAL_PANE) {
                    tree.uploadFiles();
                } else if (mode == SftpClientPanel.REMOTE_PANE) {
                    tree.downloadFiles();
                }
            }
        });
    }

}
