/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : HostSelectorCombo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh.hosts;

import java.io.Serializable;

import javax.swing.JComboBox;

import org.apache.log4j.Logger;

public class HostSelectorCombo extends JComboBox implements HostSelector,
        Serializable {
    private static Logger logger = Logger.getLogger(HostSelectorCombo.class
            .getName());

    private String FS = System.getProperty("file.separator");
    private HostList list;

    public HostSelectorCombo() {
        super();
        init();
    }

    private void init() {
        list = HostList.getHostList();
        int numHosts = list.size();
        for (int i = 0; i < numHosts; i++) {
            HostInfo info = list.getHostInfo(i);
            this.addItem(info.getName());
        }
        HostInfo def = list.getDefaultHost();
        logger.debug("default host: " + def.getName());
        setSelectedItem(def.getName());
    }

    public HostInfo getSelectedHost() {
        return list.getHostInfo(getSelectedIndex());
    }

    public HostList getListofHosts() {
        return this.list;
    }

    public void debug() {
        list.debug();
    }

    public int getSelectedIndex() {
        return super.getSelectedIndex();
    }

    public void recreate() {
    }

    public void addHost(HostInfo hostInfo) {
        // TODO Auto-generated method stub
        this.list.addLast(hostInfo);
        addItem(hostInfo.getName());
    }

    public void deleteSelectedHost() {
        // TODO Auto-generated method stub
        HostInfo hi = list.getHostInfo(getSelectedIndex());
        this.list.remove(hi);
        this.removeItem(hi);
    }

}
