/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : KnownHosts.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh;

import java.io.File;

import com.jcraft.jsch.JSch;

public class KnownHosts {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(KnownHosts.class.getName());
    private static final String known_hosts_string = System
            .getProperty("user.home")
            + System.getProperty("file.separator")
            + ".phase-viewer"
            + System.getProperty("file.separator")
            + "known_hosts";

    public static JSch getJSch() {
        JSch jsch = null;
        File known_hosts = new File(known_hosts_string);
        try {
            jsch = new JSch();
            jsch.setKnownHosts(known_hosts.getAbsolutePath());

            if (new File(System.getProperty("user.home")
                    + System.getProperty("file.separator") + ".ssh"
                    + System.getProperty("file.separator") + "id_rsa").exists()) {
                jsch.addIdentity(System.getProperty("user.home")
                        + System.getProperty("file.separator") + ".ssh"
                        + System.getProperty("file.separator") + "id_rsa");
                logger.info("added identity");
            }

            // HostKeyRepository hkr = jsch.getHostKeyRepository();
            // HostKey[] hks = hkr.getHostKey();
            // if (hks != null) {
            // logger.debug("Host keys in " + hkr.getKnownHostsRepositoryID());
            // for (int i = 0; i < hks.length; i++) {
            // HostKey hk = hks[i];
            // logger.debug(hk.getHost() + " " + hk.getType() + " "
            // + hk.getFingerPrint(jsch));
            // }
            // }
        } catch (Exception exc) {
            exc.printStackTrace();
            logger.error("failed to initialize jsch");
        }
        return jsch;
    }

}
