/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/17, 11:39
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectState.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectstatemanipulator;

import org.apache.log4j.Logger;

import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;

/**
 * vWFNg̏Ԃێ\
 * 
 * @author
 */
public class ProjectState {
    private Logger logger = Logger.getLogger(ProjectState.class.getName());
    public static int PROJECT_RENAME = 0;
    public static int PROJECT_CUT = 1;
    public static int PROJECT_COPY = 2;
    public static int PROJECT_PASTE = 3;

    private int projectState = PROJECT_RENAME;
    private ProjectInfo projectInfo;

    private ProjectDirBrowserNode node;
    private ProjectDirBrowserNode parentNode;

    /**
     * Creates a new instance of ProjectState
     * 
     * @param projectInfo
     *            vWFNg
     * @param projectState
     *            vWFNg̏
     */
    public ProjectState(ProjectInfo projectInfo, int projectState) {
        this.projectInfo = projectInfo;
        this.projectState = projectState;
    }

    /**
     * @param node
     *            ێvWFNg\m[h.
     * @param parentNode
     *            node̐em[h.
     * @param projectState
     *            vWFNg̏
     */
    public ProjectState(ProjectDirBrowserNode node,
            ProjectDirBrowserNode parentNode, int projectState) {
        this.node = node;
        this.parentNode = parentNode;
        this.projectState = projectState;
    }

    /**
     * vWFNg擾
     * 
     * @return vWFNg
     */
    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    /**
     * vWFNg̏Ԃ擾
     * 
     * @return vWFNg̏; PROJECT_RENAMEPROJECT_CUTPROJECT_COPYPROJECT_PASTE
     */
    public int getProjectState() {
        return this.projectState;
    }

    /**
     * vWFNg̃m[h擾
     * 
     * @return ێĂvWFNg̃m[h
     */
    public ProjectDirBrowserNode getNode() {
        return this.node;
    }

    /**
     * vWFNg̃m[h̐em[h擾
     * 
     * @return ێĂvWFNg̐em[h
     */
    public ProjectDirBrowserNode getParentNode() {
        return this.parentNode;
    }
}
