/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/17, 9:49
!  AUTHOR(S): KOGA, Junichiro
!  File : ArrowEditPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.prefs.arrow;

import java.awt.Color;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * 
 * @author
 */
public class ArrowEditPanel extends javax.swing.JPanel {
    private Logger logger = Logger.getLogger(ArrowEditPanel.class.getName());
    private GlobalProperties gp = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);
    private JInternalFrame parent;
    private CoordsViewerInterface parentParent;

    private final String arrow_draw = "arrow_draw";
    private final String arrow_draw_value = "arrow_draw_value";
    private final String arrow_head_radius = "arrow_head_radius";
    private final String arrow_head_height = "arrow_head_height";
    private final String arrow_scale = "arrow_scale";
    private final String arrow_radius = "arrow_radius";
    private final String arrow_color_r = "arrow_color_r";
    private final String arrow_color_g = "arrow_color_g";
    private final String arrow_color_b = "arrow_color_b";

    /** Creates new form ArrowEditPanel */
    public ArrowEditPanel(JInternalFrame parent,
            CoordsViewerInterface parentParent) {
        this.parent = parent;
        this.parentParent = parentParent;
        initComponents();
        setInitValues();
    }

    private Color getForegroundColor(Color color) {
        float red = ((float) color.getRed()) / 255.f;
        float green = ((float) color.getGreen()) / 255.f;
        float blue = ((float) color.getBlue()) / 255.f;
        float redscale = 0.5f;
        float greenscale = 0.5f;
        float bluescale = 0.5f;
        if (red < 0.5f) {
            redscale = 2.0f;
        }
        if (green < 0.5f) {
            greenscale = 2.0f;
        }
        if (blue < 0.5f) {
            bluescale = 2.0f;
        }
        return new Color(red * redscale, green * greenscale, blue * bluescale);
    }

    private void setInitValues() {
        boolean draw = new Boolean(gp.getProperty(arrow_draw)).booleanValue();
        boolean drawval = new Boolean(gp.getProperty(arrow_draw_value))
                .booleanValue();
        String radius = gp.getProperty(arrow_head_radius);
        String height = gp.getProperty(arrow_head_height);
        String scale = gp.getProperty(arrow_scale);
        String radi = gp.getProperty(arrow_radius);

        String color_r = gp.getProperty(arrow_color_r);
        String color_g = gp.getProperty(arrow_color_g);
        String color_b = gp.getProperty(arrow_color_b);

        float red = 1.0f;
        float blue = 1.0f;
        float green = 1.0f;
        try {
            red = Float.parseFloat(color_r);
            green = Float.parseFloat(color_g);
            blue = Float.parseFloat(color_b);
        } catch (Exception e) {
        }
        Color color = new Color(red, green, blue);

        drawCheckBox.setSelected(draw);
        drawValueCheckBox.setSelected(drawval);
        headRadius.setText(radius);
        headHeight.setText(height);
        arrowScale.setText(scale);
        arrowRadius.setText(radi);
        arrowColor.setBackground(color);
        arrowColor.setForeground(getForegroundColor(color));
    }

    private JCheckBox drawValueCheckBox;

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed"
    // desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        drawCheckBox = new javax.swing.JCheckBox();
        drawValueCheckBox = new JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        headRadius = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        headHeight = new javax.swing.JTextField();
        arrowColor = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        arrowScale = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        arrowRadius = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();

        JPanel pcheckbox = new JPanel();
        pcheckbox.setLayout(new BoxLayout(pcheckbox, BoxLayout.X_AXIS));
        drawCheckBox.setText("draw arrows to represent force");
        drawCheckBox.setActionCommand("draw arrows to represent force");
        drawCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0,
                0, 0, 0));
        drawCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        pcheckbox.add(drawCheckBox);
        drawValueCheckBox.setText("draw value");
        pcheckbox.add(drawValueCheckBox);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
                "appearance",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS UI Gothic", 0, 12), new java.awt.Color(0,
                        51, 153)));
        jPanel2.setBorder(javax.swing.BorderFactory
                .createTitledBorder("arrowhead radius"));
        headRadius.setBorder(null);
        headRadius.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                headRadiusCaretUpdate(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(
                jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.TRAILING,
                jPanel2Layout
                        .createSequentialGroup()
                        .addContainerGap()
                        .add(headRadius,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                92, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(headRadius,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE));

        jPanel3.setBorder(javax.swing.BorderFactory
                .createTitledBorder("arrowhead height"));
        headHeight.setBorder(null);

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(
                jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.TRAILING,
                jPanel3Layout
                        .createSequentialGroup()
                        .addContainerGap()
                        .add(headHeight,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                98, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(headHeight,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE));

        arrowColor.setForeground(new java.awt.Color(0, 153, 153));
        arrowColor.setText("arrow color");
        arrowColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                arrowColorActionPerformed(evt);
            }
        });

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("scale"));
        arrowScale.setBorder(null);

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(
                jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.TRAILING,
                jPanel4Layout
                        .createSequentialGroup()
                        .addContainerGap()
                        .add(arrowScale,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                86, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(arrowScale,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE));

        jPanel5.setBorder(javax.swing.BorderFactory
                .createTitledBorder("arrow radius"));
        arrowRadius.setBorder(null);

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(
                jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.TRAILING,
                jPanel5Layout
                        .createSequentialGroup()
                        .addContainerGap()
                        .add(arrowRadius,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                86, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(arrowRadius,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE));

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(
                jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout
                .setHorizontalGroup(jPanel1Layout
                        .createParallelGroup(
                                org.jdesktop.layout.GroupLayout.LEADING)
                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                jPanel1Layout
                                        .createSequentialGroup()
                                        .addContainerGap()
                                        .add(jPanel1Layout
                                                .createParallelGroup(
                                                        org.jdesktop.layout.GroupLayout.TRAILING)
                                                .add(jPanel4,
                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                                .add(org.jdesktop.layout.GroupLayout.TRAILING,
                                                        jPanel1Layout
                                                                .createSequentialGroup()
                                                                .add(jPanel5,
                                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                                                .addPreferredGap(
                                                                        org.jdesktop.layout.LayoutStyle.RELATED)))
                                        .add(jPanel1Layout
                                                .createParallelGroup(
                                                        org.jdesktop.layout.GroupLayout.LEADING)
                                                .add(org.jdesktop.layout.GroupLayout.LEADING,
                                                        jPanel1Layout
                                                                .createSequentialGroup()
                                                                .addPreferredGap(
                                                                        org.jdesktop.layout.LayoutStyle.RELATED)
                                                                .add(jPanel2,
                                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                                                .addPreferredGap(
                                                                        org.jdesktop.layout.LayoutStyle.RELATED)
                                                                .add(jPanel3,
                                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                                .add(org.jdesktop.layout.GroupLayout.LEADING,
                                                        jPanel1Layout
                                                                .createSequentialGroup()
                                                                .add(38, 38, 38)
                                                                .add(arrowColor)))
                                        .addContainerGap()));
        jPanel1Layout
                .setVerticalGroup(jPanel1Layout
                        .createParallelGroup(
                                org.jdesktop.layout.GroupLayout.LEADING)
                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                jPanel1Layout
                                        .createSequentialGroup()
                                        .add(jPanel2,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(
                                                org.jdesktop.layout.LayoutStyle.RELATED,
                                                18, Short.MAX_VALUE)
                                        .add(arrowColor).addContainerGap())
                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                jPanel1Layout
                                        .createSequentialGroup()
                                        .add(jPanel5,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(
                                                org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(jPanel4,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .add(32, 32, 32))
                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                jPanel1Layout
                                        .createSequentialGroup()
                                        .add(jPanel3,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .addContainerGap(82, Short.MAX_VALUE)));

        jButton2.setText("apply");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jButton3.setText("close");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
                this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(org.jdesktop.layout.GroupLayout.LEADING,
                        layout.createSequentialGroup().add(24, 24, 24)
                                .add(pcheckbox)
                                .addContainerGap(151, Short.MAX_VALUE))
                .add(jPanel1)
                .add(org.jdesktop.layout.GroupLayout.LEADING,
                        layout.createSequentialGroup()
                                .add(149, 149, 149)
                                .add(jButton2)
                                .addPreferredGap(
                                        org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jButton3)
                                .addContainerGap(156, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(org.jdesktop.layout.GroupLayout.LEADING,
                        layout.createSequentialGroup()
                                .addContainerGap()
                                .add(pcheckbox)
                                .addPreferredGap(
                                        org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jPanel1,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                        120,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(
                                        org.jdesktop.layout.LayoutStyle.RELATED,
                                        13, Short.MAX_VALUE)
                                .add(layout
                                        .createParallelGroup(
                                                org.jdesktop.layout.GroupLayout.BASELINE)
                                        .add(jButton2).add(jButton3))
                                .addContainerGap()));
    }

    // </editor-fold>//GEN-END:initComponents

    private void arrowColorActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_arrowColorActionPerformed
        // TODO add your handling code here:
        JColorChooser colorchooser = new JColorChooser();
        Color color = colorchooser.showDialog(parent, "Choose",
                arrowColor.getBackground());
        if (color != null) {
            arrowColor.setBackground(color);
            arrowColor.setForeground(getForegroundColor(color));
        }
    }// GEN-LAST:event_arrowColorActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButton2ActionPerformed
        // TODO add your handling code here:
        String headrad = headRadius.getText();
        String headhei = headHeight.getText();
        String scale = arrowScale.getText();
        String radi = arrowRadius.getText();
        boolean draw = drawCheckBox.isSelected();
        boolean drawval = drawValueCheckBox.isSelected();
        Color color = arrowColor.getBackground();

        try {
            Float.parseFloat(headrad);
            Float.parseFloat(headhei);
            Float.parseFloat(scale);
            Float.parseFloat(radi);
        } catch (Exception exc) {
            logger.warn("enter a valid number.");
            return;
        }

        String red = String.valueOf(((float) color.getRed()) / 255.f);
        String green = String.valueOf(((float) color.getGreen()) / 255.f);
        String blue = String.valueOf(((float) color.getBlue()) / 255.f);

        gp.setProperty(arrow_draw, String.valueOf(draw));
        gp.setProperty(arrow_draw_value, String.valueOf(drawval));
        gp.setProperty(arrow_head_radius, headrad);
        gp.setProperty(arrow_head_height, headhei);
        gp.setProperty(arrow_scale, scale);
        gp.setProperty(arrow_radius, radi);
        gp.setProperty(arrow_color_r, red);
        gp.setProperty(arrow_color_g, green);
        gp.setProperty(arrow_color_b, blue);

        gp.storeProperty();

        parentParent.getCD().update();
    }// GEN-LAST:event_jButton2ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButton3ActionPerformed
        // TODO add your handling code here:
        parent.dispose();
    }// GEN-LAST:event_jButton3ActionPerformed

    private void headRadiusCaretUpdate(javax.swing.event.CaretEvent evt) {// GEN-FIRST:event_headRadiusCaretUpdate
        // TODO add your handling code here:
    }// GEN-LAST:event_headRadiusCaretUpdate

    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JButton arrowColor;
    public javax.swing.JTextField arrowRadius;
    public javax.swing.JTextField arrowScale;
    public javax.swing.JCheckBox drawCheckBox;
    public javax.swing.JTextField headHeight;
    public javax.swing.JTextField headRadius;
    public javax.swing.JButton jButton2;
    public javax.swing.JButton jButton3;
    public javax.swing.JPanel jPanel1;
    public javax.swing.JPanel jPanel2;
    public javax.swing.JPanel jPanel3;
    public javax.swing.JPanel jPanel4;
    public javax.swing.JPanel jPanel5;
    // End of variables declaration//GEN-END:variables

}
