/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/23, 16:03
!  AUTHOR(S): KOGA, Junichiro
!  File : ImportAction.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.file;

import java.awt.event.ActionEvent;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ACVAction;
import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.ImportFileChooser;
import ciss.phase_viewer.atomcoord.io.Importable;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;

/**
 * t@CWC|[gNX
 * 
 * @author
 */
public class ImportAction extends ACVAction implements Importable, ACVCaller {
    private Logger logger = Logger.getLogger(ImportAction.class.getName());

    /** Creates a new instance of ImportAction */
    public ImportAction(MainPanel parent) {
        super(parent);
    }

    public void actionPerformed(ActionEvent e) {
        // ImporterGUIHeavy importer = new ImporterGUIHeavy(this);
        ImportFileChooser ifc = new ImportFileChooser(this, parent);
    }

    public void coordsImported(AtomCoords[] coords, String type, String fileName) {
        try {
            Vector vec = new Vector();
            for (int i = 0; i < coords.length; i++) {
                vec.addElement(coords[i]);
            }
            DataManager dm = new DataManager("foo", PhaseConstants.TABLESPEC,
                    false);
            dm.parse();
            ACVData data = new ACVData(this, vec, "", dm.getInputInterface(),
                    StringConstants.phase_atom_tag);
            data.setFileName(new java.io.File(fileName).getName());
            // parent.setFrame(coords);
            ((CoordsViewerInterface) parent).setData(data);
            ((CoordsViewerInterface) parent).display3D();
            parent.setSelected(true);
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void save(AtomCoords coords) {
    }
}
