/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/16, 12:50
!  AUTHOR(S): KOGA, Junichiro
!  File : Output000Parser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel.parsers;

import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * epsmain̕Wo͗pparser.
 * 
 * @author
 */
public class Output000Parser extends OutputParser {
    private Logger logger = Logger.getLogger(Output000Parser.class.getName());

    public static final String OSCILLATOR = "oscillator";
    private final String oscillatorTag = "!* oscillator strength per electron";
    private String oscillator = "(not available)";

    public static final String ALL_KPOINTS = "all kpoints";
    private final String allKpointsTag = "All kpoints have been calculated";
    private String allKpoints = "no";

    public static final String LIST_OF_BAND = "list of band numbers";
    private final String listOfBandTag = "---------- list of band numbers for each spin ----------";
    private Vector list_of_band;
    boolean b_list_of_band = false;

    public static final String BANDGAP = "band gap";
    private final String bandGapTag = "---------- band gap ---------";
    private String bandGap = "(not available)";
    private boolean b_bandgap = false;

    public static final String STATIC_TENSOR = "static tensor";
    private final String staticTensorTag = "<< UVSOR-Epsilon   FINALIAZTION STARTS";
    private String staticTensor = "(not available)";
    private boolean b_static = false;

    public static final String EFFECTIVE_MASS = "effective mass";
    private final String effectiveMassTag = "---------- effective mass calculation ----------";
    private String effectiveMass = "(not available)";
    private boolean b_effective = false;

    /** Creates a new instance of Output000Parser */
    public Output000Parser(String fileName) {
        super(fileName);
        // output000͕ʃXbhƂǂɂ܂sȂ. ȑΏ.
        super.invokeNewThread = false;
        logger.debug("fileName: " + fileName);
    }

    protected boolean parse() {
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                parseLine(line.trim());
            }
        } catch (Exception exc) {
        } finally {
            try {
                reader.close();
            } catch (Exception exc) {
            }
        }
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith(oscillatorTag)) {
            String[] osc = line.split("=");
            try {
                oscillator = osc[1].trim();
            } catch (Exception exc) {
            }
        }

        if (line.startsWith(allKpointsTag)) {
            allKpoints = "yes";
        }

        if (line.startsWith(listOfBandTag) && !b_list_of_band) {
            int count = 0;
            if (list_of_band == null)
                list_of_band = new Vector();
            try {
                while (count < 10) {
                    String tmpline = reader.readLine();
                    if (tmpline.trim().length() == 0)
                        continue;
                    if (tmpline.trim().startsWith("total number of electron"))
                        break;
                    list_of_band.addElement(tmpline.trim());
                    count++;
                }
            } catch (Exception exc) {
            }
            b_list_of_band = true;
        }

        if (line.startsWith(bandGapTag) && !b_bandgap) {
            int count = 0;
            bandGap = "";
            try {
                while (count < 8) {
                    String tmpline = reader.readLine().trim();
                    tmpline = tmpline.replaceAll("!\\*", "");
                    String[] tmp = tmpline.split("\\s+");
                    String tmptmp = "";
                    for (int i = 0; i < tmp.length; i++)
                        tmptmp += tmp[i] + " ";
                    bandGap += tmptmp + System.getProperty("line.separator");
                    count++;
                }
            } catch (Exception exc) {
            }
            b_bandgap = true;
        }

        if (line.startsWith(staticTensorTag)) {
            int count = 0;
            staticTensor = "";
            try {
                while (count < 13) {
                    String tmpline = reader.readLine().trim();
                    if (tmpline.startsWith("<< UVSOR-Epsilon"))
                        break;
                    if (tmpline.startsWith("!* static dielectric constant")
                            || tmpline.startsWith("xx")
                            || tmpline.startsWith("xy")
                            || tmpline.startsWith("yx")
                            || tmpline.startsWith("yy")
                            || tmpline.startsWith("zx")
                            || tmpline.startsWith("zy")
                            || tmpline.startsWith("Static")
                            || tmpline.startsWith("SHG")) {
                        staticTensor += tmpline
                                + System.getProperty("line.separator");
                    }
                }
            } catch (Exception exc) {
            }
        }

        if (line.startsWith(effectiveMassTag)) {
            int count = 0;
            effectiveMass = line + System.getProperty("line.separator");
            while (count < 100) {
                try {
                    String tmpline = reader.readLine().trim();
                    if (tmpline.startsWith("!* ispin in tmsq"))
                        break;
                    effectiveMass += tmpline
                            + System.getProperty("line.separator");
                } catch (Exception exc) {
                }
            }
        }

    }

    public String[] getGenericData(String key) {
        if (key.equals(OSCILLATOR)) {
            return new String[] { oscillator };
        }
        if (key.equals(ALL_KPOINTS)) {
            return new String[] { allKpoints };
        }
        if (key.equals(LIST_OF_BAND)) {
            if (list_of_band == null) {
                return new String[] { "(not available)" };
            }
            String[] ret = new String[list_of_band.size()];
            list_of_band.copyInto(ret);
            return ret;
        }
        if (key.equals(BANDGAP)) {
            return new String[] { bandGap };
        }
        if (key.equals(STATIC_TENSOR)) {
            return new String[] { staticTensor };
        }
        if (key.equals(EFFECTIVE_MASS)) {
            return new String[] { effectiveMass };
        }

        return super.getGenericData(key);
    }

    public String getCurrentMessage() {
        return null;
    }

}
