/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/23, 17:27
!  AUTHOR(S): KOGA, Junichiro
!  File : TransitionMomentPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.preparationpanel;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author
 */
public class TransitionMomentPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(GeneralPanel.class.getName());

    /** Creates a new instance of GeneralPanel */
    public TransitionMomentPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new SubPanel(projectInfo.getInputInterface()), BorderLayout.NORTH);
    }

    class SubPanel extends PhaseInputItems {
        SubPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            String[] spectype = new String[] { "epsilon.transition_moment.type" };
            String[] choicetype = new String[] { "l", "rn", "ks" };
            ChoicePanelPhase type = new ChoicePanelPhase(spectype,
                    inputInterface, "type", choicetype, this);
            String[] specdelq = new String[] { "epsilon.transition_moment.delq" };
            InputPanelPhase delq = new InputPanelPhase(specdelq,
                    inputInterface, "delq", InputPanelPhase.NONE, 15, this);
            String[] specsymmetry = new String[] { "epsilon.transition_moment.symmetry" };
            ChoicePanelPhase symmetry = new ChoicePanelPhase(specsymmetry,
                    inputInterface, "symmetry", ON_OFF, this);
            JPanel p1 = new JPanel();
            p1.setLayout(new GridLayout(1, 3));
            p1.add(type);
            p1.add(delq);
            p1.add(symmetry);

            String[] specbandi = new String[] { "epsilon.transition_moment.band_i" };
            InputPanelPhase bandi = new InputPanelPhase(specbandi,
                    inputInterface, "band_i", InputPanelPhase.NONE, 15, this);
            String[] specbandf = new String[] { "epsilon.transition_moment.band_f" };
            InputPanelPhase bandf = new InputPanelPhase(specbandf,
                    inputInterface, "band_f", InputPanelPhase.NONE, 15, this);
            JPanel p2 = new JPanel();
            p2.setLayout(new BoxLayout(p2, BoxLayout.X_AXIS));
            p2.add(bandi);
            p2.add(bandf);

            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
            p.add(p1);
            p.add(p2);

            add(p);
        }

    }
}
