/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 13:24
!  AUTHOR(S): KOGA, Junichiro
!  File : StructuralEvolutionPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class StructuralEvolutionPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(StructuralEvolutionPanel.class
            .getName());

    /** Creates a new instance of StructuralEvolutionPanel */
    public StructuralEvolutionPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(
                new StructuralEvolutionPanelPanel(projectInfo));
        add(scr);
    }

    public void init() {
    }

    public void initializeProject() {
    }

}

class StructuralEvolutionPanelPanel extends PhaseInputItems {
    private static Logger logger = Logger
            .getLogger(StructuralEvolutionPanelPanel.class.getName());

    protected StructuralEvolutionPanelPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void createGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        JPanel pb = new JPanel();
        JButton btnMD = new JButton("configure MD");
        pb.add(btnMD);
        btnMD.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MDConfig mc = new MDConfig(projectInfo);
            }
        });

        JPanel pun = new JPanel();
        JButton btnUnitCell = new JButton("lattice optimization");
        btnUnitCell.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                new UnitCellConfig(projectInfo);
            }
        });
        pun.add(btnUnitCell);

        // method
        JPanel p_strctevl = new JPanel();
        p_strctevl.setLayout(new GridLayout(1, 2, 1, 1));

        String[] specmethod = { "structure_evolution.method" };
        String[] methods = { NO_SELECTION, "quench", "bfgs", "gdiis", "cg",
                "velocity_verlet", "temperature_control" };
        ChoicePanelPhase cppmethod = new ChoicePanelPhase(specmethod,
                inputInterface, "method", methods, this);
        cppmethod.registerDisabableGUI(new int[] { 0, 1, 2, 3 }, btnMD);
        p_strctevl.add(cppmethod);

        String[] specdt = { "structure_evolution.dt" };
        InputPanelPhase ippdt = new InputPanelPhase(specdt, inputInterface,
                "dt", InputPanelPhase.NONE, 10, this);
        p_strctevl.add(ippdt);

        p_strctevl.setBorder(new TitledBorder("method"));
        p.add(p_strctevl);

        // gdiis
        JPanel p_gdiis = new JPanel();
        p_gdiis.setLayout(new GridLayout(2, 2, 1, 1));

        String[] specbsize = { "structure_evolution.gdiis.gdiis_box_size" };
        InputPanelPhase ippbsize = new InputPanelPhase(specbsize,
                inputInterface, "gdiis_box_size", InputPanelPhase.NONE, 10,
                this);
        p_gdiis.add(ippbsize);

        String[] spechnew = { "structure_evolution.gdiis.gdiis_hownew" };
        String[] hnews = { NO_SELECTION, "anew", "renew" };
        ChoicePanelPhase cpphnew = new ChoicePanelPhase(spechnew,
                inputInterface, "gdiis_hownew", hnews, this);
        p_gdiis.add(cpphnew);

        String[] specforc = { "structure_evolution.gdiis.c_forc2gdiis" };
        InputPanelPhase ippforc = new InputPanelPhase(specforc, inputInterface,
                "c_forc2gdiis", InputPanelPhase.FORCE, 10, this);
        p_gdiis.add(ippforc);

        String[] specite = { "structure_evolution.gdiis.c_iteration2GDIIS" };
        InputPanelPhase ippite = new InputPanelPhase(specite, inputInterface,
                "c_iteration2GDIIS", InputPanelPhase.NONE, 10, this);
        p_gdiis.add(ippite);
        p_gdiis.setBorder(new TitledBorder("gdiis"));
        p.add(p_gdiis);

        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4, 5 }, ippbsize);
        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4, 5 }, cpphnew);
        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4, 5 }, ippforc);
        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4, 5 }, ippite);

        ChoicePanelPhase cppstress = new ChoicePanelPhase(
                new String[] { "structure_evolution.stress.sw_stress" },
                inputInterface, "calculate stress tensor", ON_OFF,
                ON_OFF_DUPLI, this);
        JPanel p_stress = new JPanel();
        p_stress.setLayout(new GridLayout(1, 3));
        p_stress.add(cppstress);
        p_stress.add(pb);
        p_stress.add(pun);
        p.add(p_stress);

        JScrollPane scr = new JScrollPane();
        String[] atmtable = new String[] { "structure.atom_list.atoms" };
        int[] map = { 0, 1, 2, 3, 4, 5 };
        TableForInputInterface tfii = new TableForInputInterface(atmtable,
                inputInterface, map, this);
        scr.getViewport().setView(tfii.getPanel());
        scr.setPreferredSize(new Dimension(500, 150));
        p.add(scr);

        this.add(p);
    }

}
