/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/16, 20:25
!  AUTHOR(S): KOGA, Junichiro
!  File : ChargeChecker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.ekcal.inputcheck;

import java.io.File;

import org.apache.log4j.Logger;

import ciss.phase_viewer.input.PhaseInputChecker;

/**
 * 
 * @author
 */
public class ChargeChecker extends PhaseInputChecker {
    private Logger logger = Logger.getLogger(ChargeChecker.class.getName());

    /** Creates a new instance of ChargeChecker */
    public ChargeChecker() {
    }

    public boolean isFixable() {
        return false;
    }

    public String getName() {
        return "charge";
    }

    public String getDescription() {
        return "check charge file.";
    }

    public String getCandidate() {
        return "";
    }

    public boolean fixInput() {
        return true;
    }

    public int doCheck() {
        String path = getFilePath("F_CHGT");
        if (path == null) {
            state = WARNING;
            message = "the name for the F_CHGT file is not specified.\n";
            message += "this is OK if it resides on the same directory\n";
            message += "and if you are using the default file name 'nfchgt.data'.";
            return state;
        }
        File file = new File(path);
        logger.debug("charge file: " + file.getAbsolutePath());
        logger.debug("isAbsolute: " + file.isAbsolute());
        logger.debug("does it exist? " + file.exists());
        if (file.exists() && file.length() != 0) {
            state = OK;
            message = "F_CHGT file exists \nand its file size is not zero.";
            return state;
        } else if (file.exists() && file.length() == 0) {
            state = ERROR;
            message = "F_CHGT file exists, \nbut its file size is zero.\ncheck your SCF calculation.";
        } else if (!file.exists()) {
            state = ERROR;
            message = "F_CHGT file does not exist.";
        }
        return state;
    }

}
