/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/07, 18:07
!  AUTHOR(S): KOGA, Junichiro
!  File : OutputParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.outputinterface;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.ProgressInfo;

/**
 * o̓f[^, t@Cp[XNX. ̃NX͊eX̃f[^ɂ FXKv邪, ΂͎dȂ.
 * 
 * @author
 */
public abstract class OutputParser implements Serializable, ProgressInfo {
    private Logger logger = Logger.getLogger(OutputParser.class.getName());

    protected Vector fileNames;
    protected String fileName;
    protected Vector voutputData = new Vector();

    protected LineNumberReader reader;
    protected LineNumberReader[] readers;

    private OutputInterface parent;

    protected int numLines;
    protected boolean isDone = false;

    private Vector parserListeners = new Vector();

    /**
     * Creates a new instance of OutputParser
     * 
     * @param fileName
     *            ̃NXp[Xׂt@C̃t@C
     */
    public OutputParser(String fileName) {
        this.fileName = fileName;
        fileNames = new Vector();
    }

    /**
     * ̃p[T[ǂݍރt@Cւ̎QƂԂ
     * 
     * @return t@C
     */
    public String getFileName() {
        return fileName;
    }

    public String[] getFileNames() {
        String[] boo = new String[fileNames.size()];
        fileNames.copyInto(boo);
        return boo;
    }

    public void addFile(String file) {
        fileNames.add(file);
    }

    public void resetFiles() {
        fileNames = new Vector();
    }

    /**
     * listenero^
     * 
     * @param listener
     *            ̃p[T[Ɋ֘Atꂽlistener
     */
    public void addParserListener(OutputParserListener listener) {
        for (int i = 0; i < parserListeners.size(); i++) {
            if (listener == parserListeners.get(i)) { // Xi[͍ēo^Ȃ!
                return;
            }
        }
        parserListeners.addElement(listener);
    }

    /**
     * parseς݂ǂ𔻒
     * 
     * @return parseς݂Ȃtrue
     */
    public boolean getParsed() {
        return this.parsed;
    }

    private boolean parsed = false;

    /**
     * xdoParse\bhĂ΂ꂽ炻̌doParse\bhsĂNȂ.
     * ēxdoParse\bhLɂɂ͂falseZbg.
     * 
     * @param falsȅꍇ
     *            , xparseς݂łĂparse.
     */
    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    /**
     * parse\bhĂ.
     */
    public void doParse() {
        if (parsed) {
            return;
        }

        initializeOutputDataVector();
        if (new File(fileName).exists()) {
            try {
                FileReader freader = new FileReader(fileName);
                reader = new LineNumberReader(freader);
            } catch (IOException ioe) {
                logger.error("failed to open file: " + fileName);
                ioe.printStackTrace();
            }
            numLines = ciss.phase_viewer.common.Utils.getNumLines(fileName);
            if (numLines < 0)
                numLines = 0;
        }
        for (int i = 0; i < fileNames.size(); i++) {
            numLines += ciss.phase_viewer.common.Utils.getNumLines(fileNames
                    .get(i).toString());
        }

        readers = new LineNumberReader[fileNames.size()];
        for (int i = 0; i < fileNames.size(); i++) {
            reader = readers[i];
            try {
                FileReader freader = new FileReader(fileNames.get(i).toString());
                readers[i] = new LineNumberReader(freader);
            } catch (IOException ioe) {
                logger.error("failed to open file: "
                        + fileNames.get(i).toString());
                ioe.printStackTrace();
            }
        }

        ChaseProgressMonitor monitor = ChaseProgressMonitor.getMonitor();
        monitor.setProgress(this);
        //
        // boolean ret = parse();
        // for ( int i=0 ; i<parserListeners.size() ; i++ ) {
        // ((OutputParserListener) parserListeners.get(i)).parseFinished();
        // }
        if (invokeNewThread) {
            new Thread(new Parse()).start();
        } else {
            parse();
            for (int i = 0; i < parserListeners.size(); i++) {
                ((OutputParserListener) parserListeners.get(i)).parseFinished();
            }
            isDone = false;
            monitor.stop();
        }
        parsed = true;
    }

    /**
     * t@Cǂݍ, parse. ̃\bh͕KI[o[ChKvɂ [OutputDataIuWFNg쐬.
     * O璼ڌĂԂƂ͂, doParse\bh ʂČĂ(ʃXbhŎs, Xi[parseIƂ`肷)
     * 
     * @return sfalseԂ, ƂӐ}.
     */
    protected abstract boolean parse();

    /**
     * OutputData, voutputDataɑ.
     * 
     * @param outputData݂OutputDataIuWFNg
     *            .
     */
    public void addOutputData(OutputData outputData) {
        voutputData.addElement(outputData);
    }

    /**
     * ̃p[T[̍쐬ւ̎QƂ̃Qb^[
     * 
     * @return 쐬
     */
    public OutputInterface getParent() {
        return this.parent;
    }

    /**
     * ̃p[T[̍쐬ւ̎QƂ̃Zb^[; [hɏɃZbg.
     * 
     * @param 쐬
     */
    void setParent(OutputInterface parent) {
        this.parent = parent;
        ;
    }

    /**
     * OutputDatai[ĂVector.
     */
    public void initializeOutputDataVector() {
        voutputData = new Vector();
    }

    /**
     * ̏ꍇ, OutputData͓̍. ̃\bhł悢Ȃ炱g.
     * 
     * @return OutputData̔z.
     */
    public OutputData[] getOutputData() {
        if (voutputData == null || voutputData.size() == 0) {
            return null;
        }

        OutputData[] ret = new OutputData[voutputData.size()];
        voutputData.copyInto(ret);
        return ret;
    }

    /**
     * getOutputDataŋꍇ, ̃\bhI[o[Ch(ftHgłnullԂ̂).
     * 
     * @return OutputData̔z.
     */
    public OutputData[] getOutputDataCustom() {
        return null;
    }

    /**
     * ǂ悤Ȃp. ftHgł͒PȂ󔒂Ԃ.
     * 
     * @param key
     *            Ȃ炩̎ʗp
     * @return Ȃ񂩌.
     */
    public String[] getGenericData(String key) {
        return new String[] { "" };
    }

    /**
     * ǂ悤Ȃp. ftHgł͒PȂ󔒂Ԃ.
     * 
     * @param key
     *            Ȃ炩̎ʗp
     * @return Ȃ񂩌.
     */
    public String[][] getGenericData2D(String key) {
        return new String[][] { { "" }, { "" } };
    }

    /** 'parse'̍ېVXbh쐬Ȃꍇfalseɂ */
    protected boolean invokeNewThread = true;

    public int getLength() {
        return numLines;
    }

    public int getCurrent() {
        if (reader == null)
            return 0;
        return reader.getLineNumber();
    }

    public boolean isDone() {
        return isDone;
    }

    public String getNameOfProgress() {
        return "reading " + new File(fileName).getName();
    }

    public void done() {
    }

    class Parse implements Runnable {
        public void run() {
            boolean ret = parse();
            for (int i = 0; i < parserListeners.size(); i++) {
                ((OutputParserListener) parserListeners.get(i)).parseFinished();
            }
            ChaseProgressMonitor.getMonitor().stop();
            isDone = false;
        }
    }
}
