/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/12 16:54:47
!  AUTHOR(S): KOGA, Junichiro
!  File : Orthorhombic.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord.symmetry;

public class Orthorhombic extends BravaisLattice {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(Orthorhombic.class.getName());

    public String getName() {
        return latticeSystem + " orthorhombic";
    }

    public double[][] getPrimitiveLatticeVector() {
        double[][] ret = null;
        if (latticeSystem.equals(BASE_CENTERED)) {
            ret = new double[][] { { 0.5 * a, -0.5 * b, 0 },
                    { 0.5 * a, 0.5 * b, 0 }, { 0, 0, c } };
        } else if (latticeSystem.equals(BODY_CENTERED)) {
            ret = new double[][] { { -0.5 * a, 0.5 * b, 0.5 * c },
                    { 0.5 * a, -0.5 * b, 0.5 * c },
                    { 0.5 * a, 0.5 * b, -0.5 * c } };
        } else if (latticeSystem.equals(FACE_CENTERED)) {
            ret = new double[][] { { 0, 0.5 * b, 0.5 * c },
                    { 0.5 * a, 0.0, 0.5 * c }, { 0.5 * a, 0.5 * b, 0.0 } };
        } else {
            ret = new double[][] { { a, 0, 0, }, { 0, b, 0 }, { 0, 0, c } };
        }

        return ret;
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha,
            double beta, double gamma) {
        boolean checkAngle = false;
        if (epsilonEquals(alpha, 90) && epsilonEquals(beta, 90)
                && epsilonEquals(gamma, 90))
            checkAngle = true;

        boolean checkLength = false;
        if (!epsilonEquals(a, b) && !epsilonEquals(a, c)
                && !epsilonEquals(b, c))
            checkLength = true;

        return checkAngle && checkLength;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[] { PRIMITIVE, FACE_CENTERED, BODY_CENTERED,
                BASE_CENTERED };
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec,
            double[] bvec, double[] cvec) {
        // primitive
        boolean pb1 = !epsilonEquals(avec[0], bvec[1])
                && !epsilonEquals(avec[0], cvec[2])
                && !epsilonEquals(bvec[1], cvec[2]);
        boolean pb2 = epsilonEquals(avec[1], 0) && epsilonEquals(avec[2], 0)
                && epsilonEquals(bvec[0], 0) && epsilonEquals(bvec[2], 0)
                && epsilonEquals(cvec[0], 0) && epsilonEquals(cvec[1], 0);
        if (pb1 && pb2) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = avec[0];
            ortho.b = bvec[1];
            ortho.c = cvec[2];
            ortho.alpha = ortho.beta = ortho.gamma = 90;
            ortho.latticeSystem = PRIMITIVE;
            return ortho;
        }

        // base-centered
        boolean bb1 = epsilonEquals(avec[0], bvec[0])
                && !epsilonEquals(avec[0], -avec[1])
                && epsilonEquals(avec[2], 0) && epsilonEquals(bvec[2], 0)
                && epsilonEquals(avec[1], -bvec[1]);
        boolean bb2 = epsilonEquals(cvec[0], 0) && epsilonEquals(cvec[1], 0)
                && !epsilonEquals(cvec[2], 0);
        if (bb1 && bb2) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = 2 * avec[0];
            ortho.b = 2 * bvec[1];
            ortho.c = cvec[2];
            ortho.alpha = ortho.beta = ortho.gamma = 90;
            ortho.latticeSystem = BASE_CENTERED;
            return ortho;
        }

        // body-centered
        boolean bob1 = epsilonEquals(-avec[0], bvec[0])
                && epsilonEquals(-avec[0], cvec[0]);
        boolean bob2 = epsilonEquals(avec[1], -bvec[1])
                && epsilonEquals(avec[1], cvec[1]);
        boolean bob3 = epsilonEquals(avec[2], bvec[2])
                && epsilonEquals(bvec[2], -cvec[2]);
        boolean bob4 = !epsilonEquals(-avec[0], avec[1])
                && !epsilonEquals(-avec[0], avec[2])
                && !epsilonEquals(avec[1], avec[2]);
        if (bob1 && bob2 && bob3 && bob4) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = Math.abs(avec[0]) * 2;
            ortho.b = Math.abs(avec[1]) * 2;
            ortho.c = Math.abs(avec[2]) * 2;
            ortho.alpha = 90;
            ortho.beta = 90;
            ortho.gamma = 90;
            ortho.latticeSystem = BODY_CENTERED;
            return ortho;
        }

        // face-centered
        boolean fb1 = epsilonEquals(avec[0], 0) && epsilonEquals(bvec[1], 0)
                && epsilonEquals(cvec[2], 0);
        boolean fb2 = epsilonEquals(bvec[0], cvec[0])
                && epsilonEquals(avec[1], cvec[1])
                && epsilonEquals(avec[2], bvec[2]);
        boolean fb3 = !epsilonEquals(avec[1], avec[2])
                && !epsilonEquals(bvec[0], bvec[2]);
        if (fb1 && fb2 && fb3) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = 2 * bvec[0];
            ortho.b = 2 * avec[1];
            ortho.c = 2 * bvec[2];
            ortho.alpha = ortho.beta = ortho.gamma = 90;
            ortho.latticeSystem = FACE_CENTERED;
            return ortho;
        }

        return null;
    }

    public String getCrystalSystem() {
        return "orthorhombic";
    }

}
