package ciss.phase_viewer.atomcoord.pmodel;

import java.util.ArrayList;

class Atom {
    double[] position;
    String symbol;
    String alias;

    public static void main(String args[]) {
        double pos[] = { 0.125, 0.2, 0.375 };

        Atom a = new Atom();
        Atom b = new Atom(pos);
        Atom c = new Atom("Si", "Si", pos);

        ArrayList<Atom> atomList = new ArrayList<Atom>();
        atomList.add(a);

        System.out.println("TEST:" + a);
        System.out.println("TEST:" + b);
        System.out.println("TEST:" + c);
    }

    Atom() {
        position = new double[3];
    }

    Atom(double pos[]) {
        this();
        for (int i = 0; i < 3; ++i)
            position[i] = pos[i];
    }

    Atom(String sym, String ali, double pos[]) {
        this(pos);
        symbol = sym;
        alias = ali;
    }

    public String toString() {
        String str = "(" + symbol + ", " + alias + ") " + "[" + position[0]
                + ", " + position[1] + ", " + position[2] + "]";
        return str;
    }

    Atom copy() {
        Atom atom = new Atom();

        atom.symbol = new String(this.symbol);
        atom.alias = new String(this.alias);
        for (int i = 0; i < 3; ++i)
            atom.position[i] = this.position[i];

        return atom;
    }
}
