/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomList.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord;

import java.util.LinkedList;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

import ciss.phase_viewer.common.TaggedString;

/**
 * AtomIuWFNg̎QƂĂLinkedList. {IɂLinkedList, -
 * AtomIuWFNg󂯕tȂ/ԂȂ\bh. - UndoRedoIuWFNg̑s Ȃǂ̗_.
 * 
 * @author KOGA, Junichiro
 */
public class AtomList extends LinkedList {

    private static Logger logger = Logger.getLogger(AtomList.class.getName());

    private UndoRedo undoRedo;

    private boolean updateUndoStack = true;

    private AtomCoords parent;

    private AtomStateList atomState;

    /**
     * ֘AtAtomCoordsIuWFNgɂƂRXgN^[
     * 
     * @param parent
     *            ֘AtAtomCoordsIuWFNg
     */
    public AtomList(AtomCoords parent) {
        this.parent = parent;
        undoRedo = new UndoRedo(this);
    }

    void setState(AtomStateList state) {
        this.atomState = state;
    }

    /**
     * qwłRXgN^[
     * 
     * @param atom
     *            ɓo^q
     * @param parent
     *            ֘AtAtomCoordsIuWFNg
     */
    public AtomList(Atom atom, AtomCoords parent) {
        this.parent = parent;
        undoRedo = new UndoRedo(this);
        addAtom(atom);
    }

    /**
     * deep clone쐬. , parentƂtB[h͋, q̏񂵂Rs[Ȃ, Ȃǂ̐.
     * 
     * @return AtomListdeep clone
     */
    public AtomList getCopy() {
        AtomList newList = new AtomList(parent);
        for (int i = 0; i < size(); i++) {
            Atom at = getAtomAt(i);
            newList.addAtomAt(i, at.getCopy());
        }
        return newList;
    }

    public void nullify() {
        for (int i = getNumAt() - 1; i >= 0; i--) {
            Atom at = getAtomAt(i);
            at.nullify();
        }
        if (undoRedo != null) {
            undoRedo.nullify();
            undoRedo = null;
        }
        clear();
        parent = null;
    }

    /**
     * ̃XgXMLGgɕϊ
     * 
     * @return ̃Xg, XMLGg\L
     */
    public Element getXMLElement() {
        Element element = new Element("atomlist");
        element.setAttribute(new Attribute("numatoms", String.valueOf(size())));
        for (int i = 0; i < size(); i++) {
            Atom atom = getAtomAt(i);
            element.addContent(atom.getXMLElement());
        }
        return element;
    }

    /**
     * wXMLGg炱̃NX̃CX^X쐬
     * 
     * @param atomList
     *            XMLGg; getXMLElementō쐬Ă̂Ƃ
     */
    public void createFrom(Element atomList) {
        java.util.List at = atomList.getChildren("atom");
        if (at == null || at.size() == 0) {
            logger.error("invalid atomlist");
            return;
        }
        for (int i = 0; i < at.size(); i++) {
            Atom atom = Atom.createFrom((Element) at.get(i));
            addAtom(atom);
        }
    }

    /**
     * ̃IuWFNgɊ֘AtĂAtomCoordsIuWFNg擾
     * 
     * @return ̃IuWFNgɊ֘AtĂAtomCoords
     */
    public AtomCoords getParent() {
        return parent;
    }

    protected UndoRedo getUndoRedoObject() {
        return undoRedo;
    }

    /**
     * XgɌq𑫂.
     * 
     * @param atom
     *            ݂q
     */
    public void addAtom(Atom atom) {
        undoRedo.addEntry(atom, size(), UndoRedoObject.ADD);
        addLast(atom);
        if (atomState != null)
            atomState.atomAdded();
    }

    /**
     * XgɌq𑫂.
     * 
     * @param atom
     *            ݂q
     * @param updateStack
     *            undo/redopStackXVȂꍇfalse
     */
    public void addAtom(Atom atom, boolean updateStack) {
        if (updateStack)
            undoRedo.addEntry(atom, size(), UndoRedoObject.ADD);
        addLast(atom);
        if (atomState != null)
            atomState.atomAdded();
    }

    /**
     * XgɌq𑫂. ޏꏊwł.
     * 
     * @param index
     *            CfbNX
     * @param atom
     *            ݂q
     */
    public void addAtomAt(int index, Atom atom) {
        // undoRedo.addEntry(atom, size(),UndoRedoObject.ADD);
        undoRedo.addEntry(atom, index, UndoRedoObject.ADD);
        add(index, atom);
        if (atomState != null)
            atomState.atomAdded(index);
    }

    /**
     * XgɌq𑫂. ޏꏊwł.
     * 
     * @param index
     *            CfbNX
     * @param atom
     *            ݂q
     * @param updateStack
     *            undo/redopStackXVȂꍇfalse
     */
    public void addAtomAt(int index, Atom atom, boolean updateStack) {
        // undoRedo.addEntry(atom, size(),UndoRedoObject.ADD);
        if (updateStack)
            undoRedo.addEntry(atom, index, UndoRedoObject.ADD);
        add(index, atom);
        if (atomState != null)
            atomState.atomAdded(index);
    }

    /**
     * w̌fAWAtom𑫂
     * 
     * @param elementName
     *            ݂q̌f
     * @param pos
     *            ݂q̍W
     */
    public void addAtom(String elementName, String[] pos) {
        Atom atom = new Atom(elementName, pos);
        undoRedo.addEntry(atom, size(), UndoRedoObject.ADD);
        addLast(atom);
        if (atomState != null)
            atomState.atomAdded();
    }

    /**
     * w̌f, W, auxiliaryAtom𑫂
     * 
     * @param elementName
     *            ݂q̌f
     * @param pos
     *            ݂q̍W
     * @param auxil
     *            ݂qauxiliaryȏ
     */
    public void addAtom(String elementName, String[] pos, TaggedString[] auxil) {
        Atom atom = new Atom(elementName, pos, auxil);
        undoRedo.addEntry(atom, size(), UndoRedoObject.ADD);
        addLast(atom);
        if (atomState != null)
            atomState.atomAdded();
    }

    /**
     * w̌f, W, auxiliaryAtom𑫂.
     * 
     * @param elementName
     *            ݂q̌f
     * @param pos
     *            ݂q̍W
     * @param auxil
     *            ݂qauxiliaryȏ. TaggedStringzVector
     */
    public void addAtom(String elementName, String[] pos, Vector auxil) {
        Atom atom = new Atom(elementName, pos, auxil);
        undoRedo.addEntry(atom, size(), UndoRedoObject.ADD);
        addLast(atom);
        if (atomState != null)
            atomState.atomAdded();
    }

    /**
     * ̃AhDŉ܂ł̂ڂ邩wł. ʂ͈񂾂, ؂ɉύXꍇȂǂ͕L蓾
     * 
     * @param count
     *            ̃AhDŉk邩
     */
    public void setUndoCount(int count) {
        undoRedo.setUndoCount(count);
    }

    /**
     * ԍŏ̃R}܂Ŗ߂.
     * 
     * @return ۂ͉Ȃꍇfalse.
     */
    public boolean undoToFirst() {
        boolean ret = undoRedo.undoToFirstEntry();
        return ret;
    }

    /**
     * AhDhDX^bN
     */
    public void initializeUndoRedo() {
        if (undoRedo == null)
            undoRedo = new UndoRedo(this);
        undoRedo.init();
    }

    /**
     * w̌q擾
     * 
     * @param i
     *            ~q̃CfbNX
     */
    public Atom getAtomAt(int i) {
        Atom atom;
        try {
            atom = (Atom) get(i);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("failed to get atom at: " + i);
            return null;
        }
        return atom;
    }

    /**
     * w̌qu
     * 
     * @param i
     *            uq̃CfbNX
     * @param atom
     *            Vɓo^q
     */
    public void replaceAtomAt(int i, Atom atom) {
        logger.debug("atom now: " + getAtomAt(i));
        undoRedo.addEntry(getAtomAt(i), i, UndoRedoObject.REPLACE);
        set(i, atom);
        if (atomState != null)
            atomState.atomModified(i);
    }

    /**
     * w̌qu
     * 
     * @param i
     *            uq̃CfbNX
     * @param atom
     *            Vɓo^q
     * @param undo
     *            /redopStackXVꍇɂ
     */
    public void replaceAtomAt(int i, Atom atom, boolean updateStack) {
        logger.debug("atom now: " + getAtomAt(i));
        if (updateStack) {
            undoRedo.addEntry(getAtomAt(i), i, UndoRedoObject.REPLACE);
        }
        set(i, atom);
        if (atomState != null)
            atomState.atomModified(i);
    }

    /**
     * w̌q폜
     * 
     * @param i
     *            폜q̃CfbNX
     */
    public void removeAtomAt(int i) {
        undoRedo.addEntry(getAtomAt(i), i, UndoRedoObject.REMOVE);
        remove(i);
        if (atomState != null)
            atomState.atomRemoved(i);
    }

    /**
     * w̌q폜
     * 
     * @param i
     *            폜q̃CfbNX
     * @param updateStack
     *            undo/redopStackXVȂꍇfalse
     */
    public void removeAtomAt(int i, boolean updateStack) {
        if (updateStack) {
            undoRedo.addEntry(getAtomAt(i), i, UndoRedoObject.REMOVE);
        }
        remove(i);
        if (atomState != null)
            atomState.atomRemoved(i);
    }

    /**
     * w̌q폜
     * 
     * @param atom
     *            폜q
     * @return TODO
     */
    public boolean removeAtom(Atom atom) {
        return removeAtom(atom, true);
    }

    /**
     * w̌q폜
     * 
     * @param atom
     *            폜q
     * @param undo
     *            /redõX^bNXVꍇtrue.
     * @return TODO
     */
    public boolean removeAtom(Atom atom, boolean updateStack) {
        int index = indexOf(atom);
        if (index < 0) {
            index = size();
        }
        if (updateStack)
            undoRedo.addEntry(atom, index, UndoRedoObject.REMOVE);
        boolean boo = remove(atom);
        if (atomState != null)
            atomState.atomRemoved(index);
        return boo;
    }

    /**
     * undo.
     * 
     * @return Ȃꍇfalse.
     */
    public boolean undo() {
        boolean ret = undoRedo.undo();
        logger.debug(this);
        return ret;
    }

    /**
     * redo
     * 
     * @return Ȃꍇfalse.
     */
    public boolean redo() {
        boolean ret = undoRedo.redo();
        logger.debug(this);
        return ret;
    }

    /**
     * o^Ă錴q̐Ԃ. size();\bhƓ.
     * 
     * @return o^Ă錴q
     */
    public int getNumAt() {
        return size();
    }

    /**
     * o^Ă錴q̓, virtualłȂ擾.
     */
    public int getRealNumAt() {
        int count = 0;
        for (int i = 0; i < size(); i++)
            if (!getAtomAt(i).isVirtualAtom())
                count++;
        return count;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < size(); i++) {
            ret += " atom no. " + i + " " + getAtomAt(i)
                    + System.getProperty("line.separator");
        }
        return ret;
    }
}
