/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/18, 18:01
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomBufferBranchGroup.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.TransformGroup;

import org.apache.log4j.Logger;

/**
 * uq̃obt@[vi[邽߂BranchGroup.
 * 
 * @author
 */
public class AtomBufferBranchGroup extends BranchGroup {
    private Logger logger = Logger.getLogger(AtomBufferBranchGroup.class
            .getName());

    /** Creates a new instance of AtomBufferBranchGroup */
    public AtomBufferBranchGroup() {
        super();
        setCapability(BranchGroup.ALLOW_DETACH);
        setCapability(BranchGroup.ALLOW_CHILDREN_READ);
    }

    private TransformGroup group;
    private AtomObject atomObject;

    protected void setTransformGroup(TransformGroup group) {
        this.group = group;
    }

    protected void setAtomObject(AtomObject atomObject) {
        this.atomObject = atomObject;
    }

    public TransformGroup getTransformGroup() {
        return this.group;
    }

    public AtomObject getAtomObject() {
        return this.atomObject;
    }

    public String toString() {
        return atomObject.toString();
    }
}
