/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/20, 12:01
!  AUTHOR(S): KOGA, Junichiro
!  File : SymmetryPointPicker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.fbz;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;

import org.apache.log4j.Logger;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;

/**
 * Ώ̓_pPicker.
 * 
 * @author
 */
public class SymmetryPointPicker extends PickMouseBehavior {
    private Logger logger = Logger.getLogger(SymmetryPointPicker.class
            .getName());
    private WignerSeitzCell wscell;

    /** Creates a new instance of SymmetryPointPicker */
    public SymmetryPointPicker(Canvas3D canvas, BranchGroup root,
            Bounds bounds, WignerSeitzCell wscell) {
        super(canvas, root, bounds);
        this.setSchedulingBounds(bounds);
        pickCanvas.setMode(PickTool.BOUNDS);
        this.wscell = wscell;
    }

    public void processStimulus(Enumeration criteria) {
        WakeupCriterion wakeup;
        AWTEvent[] evt = null;
        int xpos = 0, ypos = 0;

        while (criteria.hasMoreElements()) {
            wakeup = (WakeupCriterion) criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent)
                evt = ((WakeupOnAWTEvent) wakeup).getAWTEvent();
        }

        if (evt == null) {
            return;
        }

        MouseEvent mevent = null;
        if (evt[0] instanceof MouseEvent) {
            mevent = (MouseEvent) evt[0];
        }

        if (mevent == null) {
            return;
        }

        if (mevent.getButton() == MouseEvent.BUTTON1) {
            xpos = mevent.getPoint().x;
            ypos = mevent.getPoint().y;
            update(xpos, ypos);
        } else if (mevent.getButton() == MouseEvent.BUTTON2) {
            wscell.removeAllSymmetryLines();
        }

        wakeupOn(wakeupCondition);
    }

    private boolean update(int xpos, int ypos) {
        pickCanvas.setShapeLocation(xpos, ypos);
        PickResult[] result = pickCanvas.pickAllSorted();
        if (result == null) {
            logger.debug("SymmetryPointPicker returned null.");
            return false;
        }
        for (int i = 0; i < result.length; i++) {
            Primitive pri = (Primitive) result[i].getNode(PickResult.PRIMITIVE);
            if (pri != null && (pri instanceof SymmetryPoint)) {
                SymmetryPoint obj = (SymmetryPoint) pri;
                SymmetryPointBG bg = obj.getParentBG();
                logger.debug("symm. point: " + bg);
                wscell.doSymmetricPoint(bg);
                return true;
            }
        }
        return false;
    }

    public void updateScene(int xpos, int ypos) {
    }

}
