/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/01 18:04:05
!  AUTHOR(S): KOGA, Junichiro
!  File : UvsorEpsilonReportGenerator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.jobcontrolpanel;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.plugins.projectmanipulator.BasicReportGenerator;

public class UvsorEpsilonReportGenerator extends BasicReportGenerator {
    /*
     * (non-Javadoc)
     * 
     * @see
     * ciss.phase_viewer.plugins.projectmanipulator.BasicReportGenerator#getOthers
     * ()
     */
    protected String getOthers() {
        String ret = "";
        if (mostRecentStdOutFile == null) {
            ret += "\n";
            ret += "could not find standard output file.\n";
        } else {
            ret += "\n";
            ret += "standard output file : " + mostRecentStdOutFile.getName()
                    + "\n";
            ret += parseStdout(mostRecentStdOutFile);
        }
        return ret;
    }

    private String parseStdout(File file) {
        String ret = "";
        BufferedReader reader = Utils.getReader(file.getAbsolutePath());
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                String str = parseLine(line);
                if (str.length() != 0)
                    ret += str + "\n";
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            try {
                reader.close();
            } catch (IOException ioe) {
            }
        }
        return ret;
    }

    private boolean caughtAllKpoint = false;

    private boolean caughtOsi = false;

    private String parseLine(String line) {
        String ret = "";
        line = line.trim();

        if (line.startsWith("program start"))
            ret = line;
        if (line.startsWith("All kpoints") && !caughtAllKpoint) {
            ret = line;
            caughtAllKpoint = true;
        }
        if (line.startsWith("!* oscillator")) {
            ret = line;
            caughtOsi = true;
        }
        if (line.startsWith("!* static")) {
            ret = line;
        }

        return ret;
    }

    private Logger logger = Logger.getLogger(UvsorEpsilonReportGenerator.class
            .getName());

}
