/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 14:15
!  AUTHOR(S): KOGA, Junichiro
!  File : GeneralPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.file.FileTransferPanel;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectInfoChangeEvent;
import ciss.phase_viewer.projectbrowser.ProjectInfoListener;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class GeneralPanel extends ProjectManipulator implements
        ProjectInfoListener {
    private Logger logger = Logger.getLogger(GeneralPanel.class.getName());
    private JScrollPane jScrollPane;

    /*
     * (non-Javadoc)
     * 
     * @see
     * ciss.phase_viewer.projectbrowser.ProjectInfoListener#projectInfoChanged
     * (ciss.phase_viewer.projectbrowser.ProjectInfoChangeEvent)
     */
    public void projectInfoChanged(ProjectInfoChangeEvent ev) {
        if (ftp != null)
            ftp.setSelectedHost(ev.getProjectInfo().getHostInfo());
    }

    private JEditorPane jEditorPane;

    /** Creates a new instance of GeneralPanel */
    public GeneralPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        init();
    }

    private FileTransferPanel ftp;
    private JPanel panel1;

    private void initializeComponents() {
        removeAll();
        // setLayout(new GridLayout(2,1));
        setLayout(new GridBagLayout());
        // setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.HORIZONTAL;

        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.Y_AXIS));

        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();

        /*
         * ftp = (FileTransferPanel)
         * projectInfo.getGUI(FileTransferPanel.class); if ( ftp == null ) { ftp
         * = new FileTransferPanel(projectInfo); projectInfo.registerGUI(ftp); }
         */
        ftp = new FileTransferPanel(projectInfo);
        panel1.add(ftp);

        panel3.setBorder(new javax.swing.border.TitledBorder(null,
                "description",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("Arial", 1, 12)));
        panel3.setLayout(new GridLayout(1, 0));
        jScrollPane = new javax.swing.JScrollPane();
        jScrollPane
                .setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        panel3.add(jScrollPane);
        jEditorPane = new javax.swing.JEditorPane();
        jScrollPane.getViewport().setView(jEditorPane);
        jScrollPane.setPreferredSize(jEditorPane.getPreferredSize());

        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        add(panel1, c);

        c.weighty = 0.5;
        c.ipady = 330;
        c.anchor = GridBagConstraints.PAGE_END;
        c.gridx = 0;
        c.gridy = 1;
        add(panel3, c);

    }

    public void init() {
        projectInfo.addProjectInfoListener(this);
        initializeComponents();
        ProjectBrowserUtils
                .setHtmlToEditorPane(
                        jEditorPane,
                        getClass()
                                .getResource(
                                        "/ciss/phase_viewer/plugins/projectmanipulator/phase/resultsviewerpanel/resultsviewer.html"));
        revalidate();
    }

    public void initializeProject() {
    }

}
