/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 20:04
!  AUTHOR(S): KOGA, Junichiro
!  File : STMPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.postprocessing;

import java.awt.BorderLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class WorkFunc extends ProjectManipulator {
    private Logger logger = Logger.getLogger(WorkFunc.class.getName());

    public WorkFunc(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(
                new WFPanelPanel(projectInfo.getInputInterface()));
        add(scr);
    }

    public void init() {
    }

    public void initializeProject() {
    }

}

class WFPanelPanel extends PhaseInputItems {
    private static Logger logger = Logger.getLogger(WFPanelPanel.class
            .getName());

    protected WFPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    public void createGUI() {
        setLayout(new BorderLayout());
        JPanel p_wf = new JPanel();
        p_wf.setLayout(new BoxLayout(p_wf, BoxLayout.X_AXIS));
        // p_stm.setLayout(new GridLayout(1, 2, 1, 1));

        String[] swworkfunc = { "postprocessing.workfunc.sw_workfunc" };
        CheckPanelPhase cppwf = new CheckPanelPhase(swworkfunc, inputInterface,
                "output data needed for work function analysis", this);
        p_wf.add(cppwf);
        p_wf.setBorder(new TitledBorder("work function"));
        // String [] swdeficit = {"postprocessing.stm.sw_deficit_charge"};
        // ChoicePanelPhase cppdef = new
        // ChoicePanelPhase(swdeficit,inputInterface,"deficit charge output",ON_OFF,ON_OFF_DUPLI,this);
        // p_wf.add(cppdef);
        add(p_wf, BorderLayout.NORTH);
    }

}
