/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 17:12
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomCoordsPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class AtomCoordsPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(AtomCoordsPanel.class.getName());

    /** Creates a new instance of AtomCoordsPanel */
    public AtomCoordsPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        this.add(new AtomCoordsPanelPanel(projectInfo.getInputInterface()));
        // JScrollPane scr = new JScrollPane();
        // scr.getViewport().setView(new
        // AtomCoordsPanelPanel(projectInfo.getInputInterface()));
        // add(scr);
    }

    public void init() {
    }

    public void initializeProject() {
    }
}

class AtomCoordsPanelPanel extends PhaseInputItems {
    private static Logger logger = Logger.getLogger(AtomCoordsPanelPanel.class
            .getName());

    protected AtomCoordsPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    public void createGUI() {
        this.add(createStructurePanel());
    }

    private JPanel createStructurePanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout());
        p.add(new AtomConfigPanel(inputInterface, new AtomCoords()));
        return p;
    }

}
