/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Kpoints.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.AddButton;
import ciss.phase_viewer.primitiveguis.CloseButton;
import ciss.phase_viewer.primitiveguis.DeleteButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputChildrenPanel;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;

public class Kpoints extends PhaseInputChildrenPanel {
    private static Logger logger = Logger.getLogger(Kpoints.class.getName());

    public Kpoints(InputInterface inputInterface) {
        super("kpoint editor", true, true, true, true, inputInterface,
                new Dimension(500, 450));
    }

    public void createGUI() {
        Container cont = getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));
        cont.add(createEditKpointsPanel());
        cont.add(new CloseButton(this));

        setResizable(true);
    }

    public void delete() {
    }

    public void save() {
    }

    public void add() {
    }

    private JPanel createEditKpointsPanel() {
        JPanel p = new JPanel();
        p.setSize(500, 250);
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        JPanel p_element = new JPanel();
        p_element.setLayout(new BoxLayout(p_element, BoxLayout.Y_AXIS));

        String[] specKpoints = { "accuracy.ksampling.kpoints" };
        String[] columnName = { "kx", "ky", "kz", "denom", "weight" };

        TableForInputInterface table = new TableForInputInterface(specKpoints,
                inputInterface, this);

        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(table.getPanel());
        scrPane.setPreferredSize(new Dimension(450, 250));

        p_element.add(scrPane);
        p.add(p_element);
        p.add(Box.createVerticalStrut(5));

        JPanel p_element_new = new JPanel();
        p_element_new.setLayout(new GridLayout(2, 3, 1, 1));

        String[] dummy = { "" };
        InputPanelPhase kx = new InputPanelPhase(dummy, inputInterface, "kx",
                InputPanelPhase.NONE, 7);
        InputPanelPhase ky = new InputPanelPhase(dummy, inputInterface, "ky",
                InputPanelPhase.NONE, 7);
        InputPanelPhase kz = new InputPanelPhase(dummy, inputInterface, "kz",
                InputPanelPhase.NONE, 7);
        InputPanelPhase denom = new InputPanelPhase(dummy, inputInterface,
                "denom", InputPanelPhase.NONE, 7);
        InputPanelPhase weight = new InputPanelPhase(dummy, inputInterface,
                "weight", InputPanelPhase.NONE, 7);

        p_element_new.add(kx);
        p_element_new.add(ky);
        p_element_new.add(kz);
        p_element_new.add(denom);
        p_element_new.add(weight);
        p.add(p_element_new);

        PhaseInputPanelInterface[] guis = { kx, ky, kz, denom, weight };
        AddButton addButton = new AddButton(table, guis, this);
        DeleteButton deleteButton = new DeleteButton(table, this);

        JPanel p_elmbtn = new JPanel();
        p_elmbtn.setLayout(new BoxLayout(p_elmbtn, BoxLayout.X_AXIS));
        p_elmbtn.setSize(300, 50);
        p_elmbtn.add(addButton);
        p_elmbtn.add(deleteButton);
        p.add(p_elmbtn);
        p.add(Box.createVerticalStrut(5));

        return p;
    }
}
