/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/21, 17:45
!  AUTHOR(S): KOGA, Junichiro
!  File : EkConvergencePanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.ekcal.preparationpanel;

import java.awt.BorderLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * "ekconvergence" ubNҏWpGUI
 * 
 * @author
 */
public class EkConvergencePanel extends ProjectManipulator {
    private Logger logger = Logger
            .getLogger(EkConvergencePanel.class.getName());

    /** Creates a new instance of EkConvergencePanel */
    public EkConvergencePanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new EkConvPanel(projectInfo.getInputInterface()),
                BorderLayout.NORTH);
    }

    class EkConvPanel extends PhaseInputItems {
        EkConvPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            JPanel p1 = new JPanel();
            JPanel p2 = new JPanel();
            p1.setLayout(new BoxLayout(p1, BoxLayout.X_AXIS));
            p2.setLayout(new BoxLayout(p2, BoxLayout.X_AXIS));

            InputPanelPhase ippnumextrabands = new InputPanelPhase(
                    new String[] { "accuracy.ek_convergence.num_extra_bands" },
                    inputInterface, "extra_bands", InputPanelPhase.NONE, 5,
                    this);
            InputPanelPhase ippnummaxiteration = new InputPanelPhase(
                    new String[] { "accuracy.ek_convergence.num_max_iteration" },
                    inputInterface, "max_iteration", InputPanelPhase.NONE, 5,
                    this);
            InputPanelPhase ippdeltaeigenvalue = new InputPanelPhase(
                    new String[] { "accuracy.ek_convergence.delta_eigenvalue" },
                    inputInterface, "delta_eigenvalue", InputPanelPhase.ENERGY,
                    5, this);
            InputPanelPhase ippsuccession = new InputPanelPhase(
                    new String[] { "accuracy.ek_convergence.succession" },
                    inputInterface, "succession", InputPanelPhase.NONE, 5, this);
            ChoicePanelPhase cppsweig = new ChoicePanelPhase(
                    new String[] { "accuracy.ek_convergence.sw_eval_eig_diff" },
                    inputInterface, "sw_eval_eig_diff", ON_OFF, this);
            p1.add(ippnummaxiteration);
            p1.add(ippnumextrabands);
            p2.add(ippdeltaeigenvalue);
            p2.add(ippsuccession);
            p2.add(cppsweig);
            add(p1);
            add(p2);
        }
    }

}
