/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfaceTable.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface.inputinterfacetable;

import java.util.Stack;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterfaceEntry;

public class InputInterfaceTable extends InputInterfaceEntry {
    private Logger logger = Logger.getLogger(InputInterfaceTable.class
            .getName());

    private String[] tableIdentifiers;

    private String[] columnIdentifiers;
    private Vector tableData = new Vector();

    private int numRows = 0;
    private int numColumns = 0;

    private Vector listeners = new Vector();

    private InputInterfaceTableColumns[] columns;

    public static int REPLACE = 0;
    public static int REMOVE = 1;

    private int lastChangeScheme = REPLACE;

    private int[] lastChangeRow = { -1 };

    private Stack undoStack = new Stack();

    public InputInterfaceTable() {
    }

    public InputInterfaceTable(String name, String[] tableIdentifiers,
            Vector tableData) {
        super(name);
        this.tableIdentifiers = tableIdentifiers;
        this.tableData = tableData;
    }

    /**
     * InputInterfaceTablẽCX^X𐶐. ̃IuWFNg͌߂ꂽJ̐Ă邪,
     * ̃IuWFNg̍쐬ƂȂ̓t@Ce[ũe[uJ̑SĂԗĂƂ͌Ȃ. ,
     * Ƃč쐬̃J̔z̑, ̃IuWFNgXĂJ̐JvZ
     * InputInterfaceTableColumnsIuWFNg̔zĂ. , uXĂJ̐v
     * ݒt@Cǂݍ܂.
     * 
     * @param name
     *            e[u
     * @param tableIdentifiers
     *            쐬̃Jz
     * @param columns
     *            XĂJ̐̔z
     * @param tableData
     *            e[ũf[^̂. StringzVector, Vector̊evff[^̊esɑΉ.
     */
    public InputInterfaceTable(String name, String[] tableIdentifiers,
            InputInterfaceTableColumns[] columns, Vector tableData) {
        super(name);
        this.tableIdentifiers = tableIdentifiers;
        this.columns = columns;
        this.tableData = tableData;

        this.createColumnIdentifiers();
        this.fitTableDatatoSpec(tableIdentifiers);
    }

    /**
     * ŌɎ{ҏWs̍ւȂ̂폜Ȃ̂Ԃ.
     * 
     * @return ŌɎ{ύX폜ȂREMOVE, ւȂREPLACE
     */
    public int lastChangedScheme() {
        return lastChangeScheme;
    }

    /**
     * ŌɕҏWꂽs̃CfbNXԂ. ̕ύX{ꍇL蓾̂ zԂ.
     * 
     * @return ŌɕҏWꂽs̃CfbNXz.
     */
    public int[] lastChangedRow() {
        return lastChangeRow;
    }

    /**
     * J̒, w̎ʎq̃CfbNXT. Ȃꍇ, ܂̓J`ĂȂꍇ -1Ԃ.
     * 
     * @param identName
     *            ʎ
     * @return indexNameɑΉCfbNX
     */
    public int getIndexFor(String identName) {
        String[] idents = getColumnIdentifiers();
        if (idents == null)
            return -1;
        for (int i = 0; i < idents.length; i++) {
            if (idents[i].equalsIgnoreCase(identName))
                return i;
        }
        return -1;
    }

    /**
     * ̃NXɂĕ\e[u^f[^u{ĂvJJvZ,
     * InputInterfaceTableColumnsIuWFNg̔zZbg.
     * 
     * @param columns
     *            Jz.
     */
    public void setInputInterfaceTableColumns(
            InputInterfaceTableColumns[] columns) {
        this.columns = columns;
        this.createColumnIdentifiers();
        this.fitTableDatatoSpec(tableIdentifiers);
    }

    /**
     * ̃IuWFNgɊ֘AtꂽInputInterfaceTableColumnsIuWFNgԂ.
     * 
     * @return InputInterfaceTableColumns IuWFNg.
     */
    public InputInterfaceTableColumns[] getInputInterfaceTableColumns() {
        return this.columns;
    }

    /**
     * tableData܂InputSpecificationɍ킹Ċg?  (rŃJ̑Ǘ͖̂ʓ|).
     * Specificationɂ͂邯Ǔnꂽ̎ʎqɂ͂Ȃf[^ɂ͋̒lĂ.
     * 
     * @param idents
     *            ̓t@Ce[uȂǂn, s[ł\̂鎯ʎqz.
     */
    private void fitTableDatatoSpec(String[] idents) {
        if (columnIdentifiers == null || idents == null) {
            return;
        }

        int[] map = getIndexArrays(idents);
        int row = tableData.size();

        Vector tmpVec = new Vector();
        for (int j = 0; j < columnIdentifiers.length; j++) {
            logger.debug(" " + columnIdentifiers[j]);
        }

        for (int i = 0; i < row; i++) {
            String[] tmpString = (String[]) tableData.elementAt(i);
            String[] fullString = new String[columnIdentifiers.length];
            for (int j = 0; j < columnIdentifiers.length; j++) {
                if (map[j] == -1) {
                    fullString[j] = "";
                } else {
                    fullString[j] = tmpString[map[j]];
                }
                logger.debug(" " + fullString[j] + " ");
            }
            tmpVec.addElement(fullString);
        }

        tableData = tmpVec;
    }

    /**
     * ̃e[uu{ĂvJ̔z쐬. ̔zƐ悤Ƀe[uf[^̍XVȂǂ͍s.
     */
    private void createColumnIdentifiers() {
        if (columns == null) {
            return;
        }

        Vector tmpVec = new Vector();
        for (int i = 0; i < columns.length; i++) {
            if (!columns[i].ignoreOnSave()) {
                tmpVec.addElement(columns[i].getInputSpecifications());
            }
        }

        columnIdentifiers = new String[tmpVec.size()];
        for (int i = 0; i < tmpVec.size(); i++) {
            columnIdentifiers[i] = (String) tmpVec.elementAt(i);
        }
    }

    /**
     * SpecificationɂČ܂Ă鎯ʎqzԂ.
     * 
     * @return ʎq̔z(vOω邱Ƃ͂Ȃ; ZbgĂȂꍇ, 'tableidentifier'Ԃ).
     */
    public String[] getColumnIdentifiers() {
        if (columnIdentifiers == null)
            return tableIdentifiers;
        return this.columnIdentifiers;
    }

    /**
     * columnIdentifiersƈ̔z̃}bsOz߂郁\bh. R[hL. int map [] =
     * getIndexArrays(idents); for ( int i=0 ; i<subData.size() ; i++ ) { String
     * [] subdat = (String []) subData.elementAt(i); String [] fulldat = new
     * String[columnIdentifiers.length]; for ( int j=0 ;
     * j<columnIdentifiers.length ; j++ ) { if ( map[j] == -1 ) { fulldat[j] =
     * ""; } else { fulldat[j] = subdat[map[j]]; } }
     * tableData.addElement(fulldat); }
     * 
     * @param ident
     *            ̔z̓eƐ悤Ƀ}bsOz񂪍쐬.
     * @return }bsOpz. ΉvfȂꍇ-1.
     */
    private int[] getIndexArrays(String[] ident) {
        int[] map = new int[columnIdentifiers.length];
        for (int i = 0; i < columnIdentifiers.length; i++) {
            map[i] = -1;
            for (int j = 0; j < ident.length; j++) {
                if (columnIdentifiers[i].equalsIgnoreCase(ident[j])) {
                    map[i] = j;
                    break;
                }
            }
        }
        return map;
    }

    public int getEntryType() {
        return super.TABLE;
    }

    public void setTableIdentifiers(String[] tableIdentifiers) {
        if (tableIdentifiers == null)
            return;
        this.tableIdentifiers = tableIdentifiers;
        setNumColumns(tableIdentifiers.length);
    }

    /**
     * ƂsƂs܂ł̃f[^폜郁\bh.
     * 
     * @param indexfrom
     *            ̍sȍ~̃f[^폜.
     * @param indexto
     *            ̍s܂ł̃f[^폜.
     */
    public void removeTableDataRow(int indexfrom, int indexto) {
        if (indexto < indexfrom) {
            return;
        }
        lastChangeRow = new int[indexto - indexfrom];
        for (int i = indexfrom; i < indexto + 1; i++) {
            try {
                tableData.remove(i);
                tableData.trimToSize();
                lastChangeRow[i] = i;
                lastChangeScheme = REMOVE;
            } catch (ArrayIndexOutOfBoundsException oe) {
            }
        }
    }

    /**
     * ꊇ폜
     */
    public void removeAll() {
        tableData = new Vector();
    }

    /**
     * Ƃs̃f[^ւ(̍s̃CfbNX̃IuWFNg ێf[^傫ꍇ͐Vɕt). ʎqz, 
     * IuWFNgJƂ悤Ƀf[^ւ (t).
     * 
     * @param idents
     *            Ăяo̎ʎqz.
     * @param rowData
     *            1sf[^
     * @param rowIndex
     *            ւs̃CfbNX.
     */
    public void replaceTableDataRow(String[] idents, String[] rowData,
            int rowIndex) {
        if (columnIdentifiers == null || idents == null || rowData == null) {
            return;
        }

        int[] map = getIndexArrays(idents);
        String[] fulldat = new String[columnIdentifiers.length];
        String[] orig = null;
        if (rowIndex < tableData.size()) {
            orig = (String[]) tableData.elementAt(rowIndex);
        }
        for (int j = 0; j < columnIdentifiers.length; j++) {
            if (map[j] == -1) {
                if (orig == null) {
                    fulldat[j] = "";
                } else {
                    fulldat[j] = orig[j];
                }
            } else {
                fulldat[j] = rowData[map[j]];
            }
        }
        replaceTableDataRow(fulldat, rowIndex);
    }

    /**
     * Ƃs̃f[^ւ(̍s̃CfbNX̃IuWFNg ێf[^傫ꍇ͐Vɕt).
     * ʎq̃`FbNȂǂ sȂƂɒ.
     * 
     * @param rowData
     *            1sf[^.
     * @param ւs̃CfbNX
     *            .
     */
    public void replaceTableDataRow(String[] rowData, int rowIndex) {
        logger.debug("at replaceTableDataRow");
        logger.debug("size of tableData: " + tableData.size());
        if (rowIndex + 1 > tableData.size()) {
            tableData.add(rowData);
        } else {
            tableData.set(rowIndex, rowData);
        }
        lastChangeRow = new int[1];
        lastChangeRow[0] = rowIndex;
        lastChangeScheme = REPLACE;
        logger.debug("last changed row is: " + tableData.size());
    }

    /**
     * Ƃs̃f[^}(̍s̃CfbNX̃IuWFNg ێf[^傫ꍇ͐Vɕt). ʎqz, 
     * IuWFNgJƂ悤Ƀf[^}. (t).
     * 
     * @param idents
     *            Ăяo̎ʎqz.
     * @param rowData
     *            1sf[^
     * @param rowIndex
     *            ւs̃CfbNX.
     */
    public void insertTableDataRow(String[] idents, String[] rowData,
            int rowIndex) {
        if (columnIdentifiers == null || idents == null || rowData == null) {
            return;
        }
        int[] map = getIndexArrays(idents);
        String[] fulldat = new String[columnIdentifiers.length];
        String[] orig = null;
        if (rowIndex < tableData.size()) {
            orig = (String[]) tableData.elementAt(rowIndex);
        }
        for (int j = 0; j < columnIdentifiers.length; j++) {
            if (map[j] == -1) {
                if (orig == null) {
                    fulldat[j] = "";
                } else {
                    fulldat[j] = orig[j];
                }
            } else {
                fulldat[j] = rowData[map[j]];
            }
        }
        insertTableDataRow(fulldat, rowIndex);
    }

    /**
     * ƂsɃf[^}(̍s̃CfbNX̃IuWFNg ێf[^傫ꍇ͐Vɕt). ʎq̃`FbNȂǂ
     * sȂƂɒ.
     * 
     * @param rowData
     *            1sf[^.
     * @param ւs̃CfbNX
     *            .
     */
    public void insertTableDataRow(String[] rowData, int rowIndex) {
        if (rowIndex + 1 > tableData.size()) {
            tableData.add(rowData);
        } else {
            tableData.add(rowIndex, rowData);
        }
    }

    public String[] getTableIdentifiers() {
        return this.tableIdentifiers;
    }

    public Vector getTableData() {
        return this.tableData;
    }

    private void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    private void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    /**
     * uƂJɗLȃf[^ł܂܂Ăΐ^vƂzԂ.
     * 
     * @return Lȍs͐^.
     */
    public boolean[] getValidColumns() {
        String[] testidents = columnIdentifiers;
        if (columnIdentifiers == null || columnIdentifiers.length == 0) {
            testidents = tableIdentifiers;
        }

        boolean[] test = new boolean[testidents.length];
        for (int i = 0; i < testidents.length; i++) {
            test[i] = false;
        }

        for (int i = 0; i < tableData.size(); i++) {
            String[] foo = (String[]) tableData.elementAt(i);
            if (foo == null) {
                continue;
            }
            for (int j = 0; j < foo.length; j++) {
                if (foo[j] != null && foo[j].trim().length() != 0
                        && j <= test.length - 1) {
                    test[j] = true;
                }
            }
        }
        return test;
    }

    /**
     * f[^.
     */
    public void initializeData() {
        tableData = new Vector();
    }

    /**
     * for the time being, always returns false.
     */
    public boolean equals(InputInterfaceEntry entry) {
        return false;
    }

    private int chrow = -1;
    private int changeState = REPLACE;

    /**
     * uꂩωsv̏Ԃw.
     * 
     * @param ind
     *            ωs̃CfbNX.
     * @param changeState
     *            ǂ̂悤ȕωN. REPLACEREMOVE
     */
    public void setWillChangeRow(int ind, int changeState) {
        this.chrow = ind;
        this.changeState = changeState;
    }

    private void pushDummyRow(int chrow) {
        String[] dummy = new String[columnIdentifiers.length];
        for (int i = 0; i < dummy.length; i++) {
            dummy[i] = "";
        }
        RowState rowState = new RowState(dummy, columnIdentifiers, chrow);
        undoStack.push(rowState);
        replaceTableDataRow(columnIdentifiers, dummy, chrow);
    }

    public void saveState() {
        if (chrow < 0) {
            return;
        }

        logger.debug("row no. " + chrow);

        if (chrow >= tableData.size()) {
            pushDummyRow(chrow);
            return;
        }

        String[] rowdata = (String[]) tableData.elementAt(chrow);
        if (rowdata == null) {
            pushDummyRow(chrow);
            return;
        }

        String[] browdata = new String[rowdata.length];
        for (int j = 0; j < rowdata.length; j++) {
            logger.debug("saving state...: " + rowdata[j]);
            if (rowdata[j] != null) {
                browdata[j] = new String(rowdata[j]);
            }
        }

        RowState rowState = new RowState(browdata, columnIdentifiers, chrow,
                changeState);
        undoStack.push(rowState);
    }

    /**
     * usv̏ԂێĂ߂̃NX. Ƃs, s̃f[^, ʎq, CfbNXɂďԂw肷邱Ƃ \. Ȃ͂.
     */
    class RowState {
        private String[] row;
        private String[] idents;
        private int index;
        private int state = REPLACE;

        RowState(String[] row, String[] idents, int index) {
            this.row = row;
            this.idents = idents;
            this.index = index;
        }

        RowState(String[] row, String[] idents, int index, int state) {
            this.row = row;
            this.idents = idents;
            this.index = index;
            this.state = state;
        }

        int getIndex() {
            return this.index;
        }

        String[] getRowData() {
            return row;
        }

        String[] getIdentifer() {
            return this.idents;
        }

        int getState() {
            return state;
        }

    }

    /**
     * undo񂲂Ƃɍŝ, ƂsɂĈCɑSŝԂ.
     * 
     * @return true̎񂲂Ƃɍs. ftHgtrue.
     */
    public boolean undoEachColumns() {
        if (columns == null || columns[0] == null
                || columns[0].getTableSpec() == null) {
            return true;
        }

        return columns[0].getTableSpec().undoEachColumns();
    }

    /**
     * undos. undo, ss񂲂Ƃɍŝ̓ʂ肪.
     */
    public void undo() {
        if (undoStack.empty()) {
            logger.info("stack empty.");
            return;
        }

        logger.debug("at InputInterfaceTable.undo()");
        RowState state = (RowState) undoStack.pop();
        int ind = state.getIndex();
        String[] row = state.getRowData();
        String[] iden = state.getIdentifer();

        for (int i = 0; i < row.length; i++) {
            logger.debug("at undo: " + row[i]);
        }
        if (ind >= tableData.size()) {
            ind = tableData.size() - 1;
        }
        // if ( state.getState() == REMOVE ) {
        // ind = tableData.size();
        // }

        redoStack.push(state);

        if (state.getState() == REMOVE) {
            insertTableDataRow(iden, row, ind);
        } else {
            replaceTableDataRow(iden, row, ind);
        }

        if (!undoStack.empty() && columns != null && !this.undoEachColumns()) {
            RowState st = (RowState) undoStack.peek();
            if (st.getIndex() == ind) {
                undo();
            }
        }

    }

    public void redo() {
        if (redoStack.empty()) {
            logger.info("stack empty.");
            return;
        }

        logger.debug("at InputInterfaceTable.redo()");
        RowState state = (RowState) redoStack.pop();
        int ind = state.getIndex();
        String[] row = state.getRowData();
        String[] iden = state.getIdentifer();
        for (int i = 0; i < row.length; i++) {
            logger.debug("at redo: " + row[i]);
        }
        if (ind >= tableData.size()) {
            ind = tableData.size() - 1;
        }

        undoStack.push(state);
        replaceTableDataRow(iden, row, ind);

        if (!redoStack.empty() && !columns[0].getTableSpec().undoEachColumns()) {
            RowState st = (RowState) redoStack.peek();
            if (st.getIndex() == ind) {
                redo();
            }
        }

    }

    /**
     * o̍, Ƃsoۂ𔻒肷.
     * 
     * @return ƂsɗLȃf[^ȂꍇfalseԂ
     */
    public static boolean isValidRow(String[] foo) {
        if (foo == null) {
            return false;
        }
        for (int i = 0; i < foo.length; i++) {
            if (foo[i] != null && foo[i].trim().length() != 0
                    && !foo[i].trim().equals("*")) {
                return true;
            }
        }
        return false;
    }

}
