/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/02, 14:04
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseFileManager.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.file;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.jobcontrol.JobControllerElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;

/**
 * ChaseFileێ, n[hfBXNƂꂱꂵ, Ȃ.
 * 
 * @author
 */
public abstract class ChaseFileManager implements JobControllerElement {
    private Logger logger = Logger.getLogger(ChaseFileManager.class.getName());

    protected File fileSpecFile;
    protected URL specFile;
    protected Element fileInf;
    protected HostInfo hostInfo;

    protected Document fileInfoDocument;
    protected ProjectInfo projectInfo;

    public static String BASEDIR = "basedir";
    public static String BLOCK = "block";

    protected Element[] file_templates;
    protected Vector file_vector = new Vector();
    protected LinkedHashMap chaseFileInfoSpec = new LinkedHashMap();

    protected String outputDirectory = ""; // o̓t@C̃fBNg[; PHASE͏'.',
                                           // FlecsȂ񂩂͓͈ˑ.

    /**
     * RXgN^[
     * 
     * @param hostInfo
     *            zXg
     * @param specFile
     *            t@C̑Ȃǂ`XMLt@CւURL
     * @param fileSpecFile
     *            (svȏꍇL蓾邯)t@C̃pXȂǂ
     *            ߂ɕKvȃt@Cւ̃pX(PHASEȂfile_names.datat@C). ȂȂnullł悢.
     */
    public ChaseFileManager(HostInfo hostInfo, URL specFile, File fileSpecFile) {
        this.hostInfo = hostInfo;
        this.specFile = specFile;
        this.fileSpecFile = fileSpecFile;
        if (fileSpecFile != null)
            logger.debug("specFile: " + specFile.toString() + " fileSpecFile: "
                    + fileSpecFile.getAbsolutePath());
        parseSpecFile();
    }

    public void setFileSpecFile(File fileSpecFile) {
        this.fileSpecFile = fileSpecFile;
    }

    /**
     * RXgN^[; zXg̃ftHglocalhost.
     * 
     * @param specFile
     *            t@C̑Ȃǂ`XMLt@CւURL
     * @param fileSpecFile
     *            (svȏꍇL蓾邯)t@C̃pXȂǂ
     *            ߂ɕKvȃt@Cւ̃pX(PHASEȂfile_names.datat@C).
     */
    public ChaseFileManager(URL specFile, File fileSpecFile) {
        this(HostList.getHostList().getHostInfo("localhost"), specFile,
                fileSpecFile);
    }

    private void parseSpecFile() {
        Document document = XMLUtils.getDocumentFromURL(specFile);
        Element fileinf = null;
        if (document == null) {
            logger.fatal("FATAL ERROR invalid fileinfo file");
            return;
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            logger.fatal("FATAL ERROR invalid fileinfo file");
            return;
        }
        java.util.List fileinfos = rootElement.getChildren("fileinfo");
        if (fileinfos == null || fileinfos.size() == 0) {
            logger.fatal("no fileinfos in: " + specFile.toString());
            return;
        }
        for (int i = 0; i < fileinfos.size(); i++) {
            Element finfo = (Element) fileinfos.get(i);
            Attribute att = finfo.getAttribute("fileinfoname");
            if (att == null) {
                logger.fatal("invalid fileinfo.");
                return;
            }
            if (att.getValue().equals(getName())) {
                fileinf = finfo;
            }
        }
        if (fileinf == null) {
            logger.fatal("couldn't find an appropriate file info.");
            return;
        }

        Element fispec = fileinf.getChild("fileinfospec");
        java.util.List fispecList = fispec.getChildren();
        for (int i = 0; i < fispecList.size(); i++) {
            Element ele = (Element) fispecList.get(i);
            ChaseFileInfoSpec cfispec = new ChaseFileInfoSpec(ele);
            chaseFileInfoSpec.put(cfispec.getName(), cfispec);
        }

        java.util.List li = fileinf.getChildren("file");
        file_templates = new Element[li.size()];
        for (int i = 0; i < li.size(); i++) {
            file_templates[i] = (Element) li.get(i);
        }
    }

    public ChaseFileInfoSpec[] getFileInfoSpecs() {
        Collection col = chaseFileInfoSpec.values();
        ChaseFileInfoSpec[] specs = new ChaseFileInfoSpec[col.size()];
        col.toArray(specs);
        return specs;
    }

    public ChaseFileInfoSpec getFileInfoSpec(Object key) {
        Object obj = chaseFileInfoSpec.get(key);
        if (obj instanceof ChaseFileInfoSpec) {
            return (ChaseFileInfoSpec) obj;
        }
        return null;
    }

    /**
     * ̃t@C}l[W[Ɋ֘AtꂽProjectInfoZbg;
     * ProjectInfosetChaseFileManager\bh炵Ă΂Ȃ悤ɂ!!
     * 
     * @param projectInfo
     *            L̒ʂ
     */
    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        logger.debug("at setProjectInfo");
        fileInfoDocument = JobController.getJobControlDocument(projectInfo,
                this);
        logger.debug("got fileInfoDocument...");
        if (fileInfoDocument != projectInfo.getProjectPropertyDocument()) {
            // logger.error("something is wrong....");
            projectInfo.setProjectPropertyDocument(fileInfoDocument);
        } else {
            logger.debug("fileTransferDocument == projectInfo.getProjectPropertyDocument()");
        }
        save();
    }

    /**
     * ̃t@C}l[W[Ɋ֘AtꂽProjectInfoQbg
     * 
     * @return L̒ʂ
     */
    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    /**
     * o^Ăt@C, ʎqƃt@C𗊂ɒT. t@CƂċ󔒂ȂnullnƎʎq݂̂𗊂ɂ.
     * 
     * @param ident
     *            TĂt@C̎ʎq
     * @param fname
     *            TĂt@C̃t@C
     * @return TĂt@C.
     */
    private ChaseFile findFile(String ident, String fname) {
        boolean useFname = true;
        if (fname == null || fname.trim().length() == 0) {
            useFname = false;
        }
        for (int i = 0; i < file_vector.size(); i++) {
            ChaseFile cfi = (ChaseFile) file_vector.get(i);
            if (!useFname) {
                if (ident.matches(cfi.getIdentifier().getValue())) {
                    return cfi;
                }
            } else {
                if (ident.matches(cfi.getIdentifier().getValue())
                        && fname.equals(cfi.getFileName())) {
                    return cfi;
                }
            }
        }
        return null;
    }

    /**
     * t@C𑫂.
     * 
     * @param element
     *            t@C񂪋LqĂElement
     * @return ꂽt@C.
     */
    public ChaseFile addFile(Element element) {
        ChaseFile cfi = new ChaseFile(element);
        fileInf.addContent(element);
        file_vector.addElement(cfi);
        return cfi;
    }

    /**
     * t@C𑫂.
     * 
     * @param ident
     *            t@C̎ʎq
     * @param key
     *            t@C̏̎ʎq; null
     * @param value
     *            t@C̏; null
     */
    public ChaseFile addFileByKey(String ident, String key, String value) {
        for (int i = 0; i < file_templates.length; i++) {
            String ide = file_templates[i].getChildTextTrim("identifier");
            if (ident.matches(ide)) {
                logger.debug("at addFileByKey. ident: " + ident + " key: "
                        + key + " value: " + value);
                Element elem = (Element) file_templates[i].clone();
                if (key != null && value != null)
                    elem.getChild(key).setText(value);
                fileInf.addContent(elem);
                ChaseFile cfi = new ChaseFile(elem, chaseFileInfoSpec);
                file_vector.addElement(cfi);
                return cfi;
            }
        }
        return null;
    }

    /**
     * t@C𑫂.
     * 
     * @param relative_path
     *            ΃pX. project directory̑΃pXw肷.
     * @param ident
     *            ʎq
     * @param filename
     *            t@C.
     * @return t@C.
     */
    public ChaseFile addFile(String relative_path, String ident, String filename) {
        for (int i = 0; i < file_templates.length; i++) {
            String ide = file_templates[i].getChildTextTrim("identifier");
            if (ident.matches(ide)) {
                Element elem = (Element) file_templates[i].clone();
                fileInf.addContent(elem);
                ChaseFile cfi = new ChaseFile(elem, chaseFileInfoSpec);
                cfi.update("relative_path", relative_path);
                cfi.update("filename", filename);
                file_vector.addElement(cfi);
                return cfi;
            }
        }
        return null;
    }

    /**
     * w̏ꏊɃt@C𑫂
     * 
     * @param ind
     *            t@C𑫂ꏊ; ݓo^Ăt@C̐傫ꍇɑ.
     * @param relative_path
     *            ΃pX; project directory̑΃pXw.
     * @param ident
     *            ʎq
     * @param filename
     *            t@C
     * @return
     */
    public ChaseFile addFileAt(int ind, String relative_path, String ident,
            String filename) {
        for (int i = 0; i < file_templates.length; i++) {
            String ide = file_templates[i].getChildTextTrim("identifier");
            if (ident.matches(ide)) {
                Element elem = (Element) file_templates[i].clone();
                fileInf.addContent(ind, elem);
                ChaseFile cfi = new ChaseFile(elem, chaseFileInfoSpec);
                cfi.update("relative_path", relative_path);
                cfi.update("filename", filename);
                if (ind < file_vector.size() && ind >= 0)
                    file_vector.add(ind, cfi);
                else
                    file_vector.add(cfi);
                return cfi;
            }
        }
        return null;
    }

    /**
     * łɂt@CXV. t@Cn̂ŋ[|eVt@Ĉ悤 L蓾t@C̍XV. ꍇ΂đ.
     * 
     * @param ident
     *            XVt@C̎ʎq
     * @param fname
     *            XVt@C̃t@C
     * @param key
     *            XV̎ʎq
     * @param val
     *            XVl.
     */
    public void updateFile(String ident, String fname, String key, String val) {
        ChaseFile cfi = findFile(ident, fname);
        if (cfi == null) {
            addFileByKey(ident, key, val);
            return;
        }
        cfi.update(key, val);
    }

    /**
     * łɂt@CXV. t@Cn̂ŋ[|eVt@Ĉ悤 L蓾t@C̍XV.
     * l^Ul̏ꍇ𗘗p.
     * 
     * @param ident
     *            XVt@C̎ʎq
     * @param fname
     *            XVt@C̃t@C
     * @param key
     *            XV̎ʎq
     * @param val
     *            XVl.
     */
    public void updateFile(String ident, String fname, String key, boolean b) {
        String val = Boolean.toString(b);
        updateFile(ident, fname, key, val);
    }

    /**
     * łɂt@CXV. , [|eV̂悤ɕL蓾t@C ͈ԍŏɃqbĝɂKpȂ.
     * 
     * @param ident
     *            XVt@C̎ʎq.
     * @param key
     *            XV̎ʎq.
     * @param val
     *            XVl.
     */
    public void updateFile(String ident, String key, String val) {
        updateFile(ident, null, key, val);
    }

    /**
     * łɂt@CXV. , [|eV̂悤ɕL蓾t@C ͈ԍŏɃqbĝɂKpȂ.
     * l^Ul̏ꍇ͂.
     * 
     * @param ident
     *            XVt@C̎ʎq.
     * @param key
     *            XV̎ʎq.
     * @param b
     *            XVl.
     */
    public void updateFile(String ident, String key, boolean b) {
        String val = Boolean.toString(b);
        updateFile(ident, key, val);
    }

    /**
     * t@C폜.
     * 
     * @param remfile
     *            폜t@C.
     */
    public void removeFile(Object file) {
        for (int i = 0; i < file_vector.size(); i++) {
            Object obj = file_vector.get(i);
            if (obj == file) {
                logger.debug("found file to remove...");
                file_vector.remove(i);
                if (file instanceof ChaseFile) {
                    ((ChaseFile) file).getElement().detach();
                }
                break;
            }
        }
    }

    /**
     * t@C擾. ʎqɂĂ͕L蓾̂ŔzԂ. ʎqɍvt@CꍇnullԂ.
     * 
     * @param ident
     *            ~t@C̎ʎq.
     * @return ʎqɍvt@C
     */
    public ChaseFile[] getFiles(String ident) {
        Vector tmp = new Vector();
        for (int i = 0; i < file_vector.size(); i++) {
            ChaseFile cf = (ChaseFile) file_vector.get(i);
            if (ident.matches(cf.getIdentifier().getValue())) {
                tmp.addElement(cf);
            }
        }
        if (tmp.size() == 0) {
            addFileByKey(ident, null, null);
            for (int i = 0; i < file_vector.size(); i++) {
                ChaseFile cf = (ChaseFile) file_vector.get(i);
                if (ident.matches(cf.getIdentifier().getValue())) {
                    tmp.addElement(cf);
                }
            }
            if (tmp.size() == 0)
                return null;
        }
        ChaseFile[] ret = new ChaseFile[tmp.size()];
        tmp.copyInto(ret);

        return ret;
    }

    /**
     * t@C擾. ԍŏɃqbgt@CԂ. ʎqɍvt@Cꍇ, \Ȃ΃ftHg쐬,
     * łȂꍇnullԂ.
     * 
     * @param ident
     *            ~t@C̎ʎq.
     * @return ʎqɍvt@C
     */
    public ChaseFile getFile(String ident) {
        for (int i = 0; i < file_vector.size(); i++) {
            ChaseFile cf = (ChaseFile) file_vector.get(i);
            if (ident.matches(cf.getIdentifier().getValue())) {
                return cf;
            }
        }
        ChaseFile ret = addFileByKey(ident, null, null);
        save();
        return ret;
    }

    /**
     * o^ĂSt@C擾.
     * 
     * @return St@C̔z
     */
    public ChaseFile[] getFiles() {
        ChaseFile[] ret = new ChaseFile[file_vector.size()];
        file_vector.copyInto(ret);
        return ret;
    }

    /**
     * ̃IuWFNgĂzXg擾.
     * 
     * @return zXg
     */
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    /**
     * ̃IuWFNgĂzXgZbg.
     * 
     * @param zXg
     *            .
     */
    public void setHostInfo(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public void save() {
        saveSub();
        saveFileInfo();
    }

    /**
     * ł̏, fBXN֕ۑ. PHASȄꍇ, "file_names.data".
     */
    protected abstract void saveSub();

    /**
     * [`̍ŌɌĂ΂.
     */
    protected abstract void postInit();

    /**
     * FileInfo ElementǂݏIƂɌĂ΂.
     */
    protected abstract void postRead();

    /**
     * phase-viewer.xml("JobControlFile"ƌĂł)fBXNɕۑ.
     */
    protected void saveFileInfo() {
        if (fileInfoDocument == null) {
            logger.error("fileInfoDocument is NNNNNUUUULLLLL!!!!");
        }
        logger.debug("projectdir at this point: "
                + projectInfo.getProjectDirectory());
        JobController.saveJobControlFile(projectInfo.getProjectDirectory(),
                fileInfoDocument);
    }

    /**
     * FileManager̖OԂ. Ƃ, ݒt@CKvȕo肷̂Ɏg.
     * 
     * @return O
     */
    public abstract String getName();

    public void initJobControlDocument(Document doc) {
        Element root = doc.getRootElement().getChild(JobController.JOBCONTROL);
        Element fileInfo = new Element("fileinfo");
        for (int i = 0; i < file_templates.length; i++) {
            String fname = file_templates[i].getChildTextTrim("filename");
            String defname = file_templates[i].getChildTextTrim("defaultname");
            if (fname != null && fname.trim().length() != 0 || defname != null
                    && defname.trim().length() != 0) {
                fileInfo.addContent((Element) file_templates[i].clone());
            }
        }
        root.addContent(fileInfo);
        postInit();
    }

    /**
     * 'output'p̃fBNg[̃pX擾.
     */
    public String getOutputDir() {
        return outputDirectory;
    }

    /**
     * document]Ȃǂǂݍ... XVׂƂłȂ ႲɂȂĂ܂Ă.
     */
    public boolean readJobControlDocument(Document doc) {
        Element root = doc.getRootElement();
        if (root == null) {
            logger.debug("no root element...");
            return false;
        }
        Element jobControlElement = root.getChild(JobController.JOBCONTROL);
        if (jobControlElement == null) {
            logger.debug("no jobcontrol element...");
            return false;
        }
        Element elem = jobControlElement.getChild("fileinfo");
        if (elem == null) {
            logger.debug("no fileinfo...");
            return false;
        }

        fileInf = elem;
        java.util.List files = elem.getChildren("file");
        if (files == null || files.size() == 0) {
            return false;
        }

        for (int i = 0; i < files.size(); i++) {
            Element file = (Element) files.get(i);
            logger.debug("ident: " + file.getChildTextTrim("identifier"));
            file_vector.addElement(new ChaseFile(file, chaseFileInfoSpec));
        }

        postRead();
        return true;
    }

}
