/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Utils.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.settings.PropertyPanel;
import ciss.phase_viewer.ssh.hosts.HostList;

public class Utils {

    private static Logger logger = Logger.getLogger(Utils.class.getName());

    private static String FS = System.getProperty("file.separator");

    private Utils() {
    }

    /**
     * ̃fBNg[̃TCYċAIɒׂ.
     * 
     * @param dir
     *            ړĨfBNg[
     * @return TCY; File#length()ςݏd˂l
     */
    public static final int getDirSize(File dir) {
        int size = 0;
        if (!dir.isDirectory())
            return size;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; i++)
            if (files[i].isDirectory())
                size += getDirSize(files[i]);
            else
                size += files[i].length();
        return size;
    }

    /**
     * ̃t@CPrintWriter쐬, Ԃ. sꍇnull.
     * 
     * @param fileName
     *            PrintWriter쐬t@C̃t@C
     * @return fileNameɑΉPrintWriter
     */
    public static PrintWriter getPrintWriter(String fileName) {
        return getPrintWriter(fileName, false);
    }

    /**
     * ̃t@CPrintWriter쐬, Ԃ. sꍇnull.
     * 
     * @param fileName
     *            PrintWriter쐬t@C̃t@C
     * @param append
     *            ǉ[h̏ꍇtrue.
     * @return fileNameɑΉPrintWriter
     */
    public static PrintWriter getPrintWriter(String fileName, boolean append) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(fileName, append));
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return writer;
    }

    /**
     * ̃t@CBufferedReader쐬, Ԃ. sꍇnull.
     * 
     * @param fileName
     *            BufferedReader쐬t@C̃t@C.
     * @return fileNameɑΉBufferedReader.
     */
    public static BufferedReader getReader(String fileName) {
        if (!new File(fileName).exists())
            return null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return reader;
    }

    /**
     * file_names.data̎ʎq̃t@C̃t@C擾郁\bh.
     * 
     * @param ident
     *            ~t@C̎ʎq
     * @param dir
     *            file_names.datat@C݂̑fBNg[
     */
    public static String getFileName(String ident, String dir) {
        HashMap map = new HashMap();
        if (!dir.endsWith(System.getProperty("file.separator")))
            dir += System.getProperty("file.separator");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(dir
                    + "file_names.data"));
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] entry = line.split("=");
                if (entry != null && entry.length >= 2) {
                    String value = entry[1].replaceAll("'", "").trim();
                    map.put(entry[0].trim(), new File(value).getName());
                }
            }
            reader.close();
        } catch (Exception e) {
        }
        String ret = (String) map.get(ident);
        return ret;
    }

    /**
     * [|eVi[ĂfBNg[Ԃ. basedir/data/pseudopotential ȂfBNg[
     */
    public static String getDefaultPPDir() {
        return HostList.getHostList().getHostInfo("localhost")
                .getProperty("basedir")
                + System.getProperty("file.separator")
                + "data"
                + System.getProperty("file.separator") + "pseudopotential";
    }

    /**
     * boots a text editor file specified in
     * $HOME/.phase-viewer/phase-viewer.ini.
     * 
     * @param textfile
     *            the input file for the text editor.
     */
    public static void bootTextViewer(String textfile) {
        File file = new File(textfile);
        if (file.exists()) {
            String editor = PropertiesManager.getGlobalProperties(
                    PropertiesManager.PROPERTIES_PVIEWER).getProperty("editor");
            if (editor == null) {
                logger.error("specify editor");
                return;
            }
            MyThread th = new MyThread(Utils.getPathDQ(editor) + " "
                    + Utils.getPathDQ(textfile));
        } else {
            logger.error("file non-existent");
        }
    }

    /**
     * ŗ^ꂽString^Ulɕϊ. ϊphase̓t@Cdlɂ.
     * 
     * @param str
     *            ϊ.
     * @return ϊꂽbooleanl.
     */
    public static boolean getBool(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().equalsIgnoreCase("on")
                || str.trim().equalsIgnoreCase("yes")
                || str.trim().equalsIgnoreCase("1")
                || str.trim().equalsIgnoreCase("true");
    }

    /**
     * ԍŏ̕啶ɂ.
     * 
     * @param input
     *            啶ɂ
     * @return ꕶڂ啶ƂȂ
     */
    public static String firstLetterCaps(String input) {
        if (input == null) {
            return input;
        }
        String ret = input;
        char[] ch = input.toCharArray();
        if (ch != null && ch.length != 0) {
            ch[0] = Character.toUpperCase(ch[0]);
            ret = new String(ch, 0, ch.length);
        }
        return ret;
    }

    /**
     * ƂpXɑ΂, Xy[XobNXbVŃGXP[v.
     * 
     * @param pathName
     *            IWĩpX.
     * @return sꂽpX.
     */
    private static String getPath(String pathName) {
        String FS = System.getProperty("file.separator");
        Vector pathVector = new Vector();

        StringTokenizer st = new StringTokenizer(pathName, FS);
        while (st.hasMoreTokens()) {
            pathVector.addElement(st.nextToken());
        }

        String path = new String();
        Vector newPathVector = new Vector();
        String replaceString = "\\\\ ";
        for (int i = 0; i < pathVector.size(); i++) {
            path = (String) pathVector.get(i);
            // System.out.println("old path: "+path);
            String newPath = path.replaceAll("\\s", replaceString);
            // System.out.println("new path: "+newPath);
            newPathVector.addElement(newPath);
        }

        if (newPathVector.size() == 1) {
            return (String) newPathVector.get(0);
        }

        path = new String();
        for (int i = 0; i < newPathVector.size(); i++) {
            path += FS + (String) newPathVector.get(i);
        }

        return path;
    }

    /**
     * VXẽNbv{[h֕n\bh
     * 
     * @param str
     *            n
     */
    public static void toClipboard(String str) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(str);
        clip.setContents(ss, ss);
    }

    /**
     * ̒, 𔲂oĕԂ.
     * 
     * @param string
     *            ̕
     * @return ͏Ȃꂽstring.
     */
    public static String stripNumber(String string) {
        char[] cha = string.toCharArray();
        Vector vec = new Vector();
        for (int i = 0; i < cha.length; i++) {
            if (!Character.isDigit(cha[i]))
                vec.addElement(new Character(cha[i]));
        }
        char[] retchar = new char[vec.size()];
        for (int i = 0; i < retchar.length; i++)
            retchar[i] = ((Character) vec.get(i)).charValue();
        return new String(retchar);
    }

    public static String NO_CANDIDATE = "(no candidate)";

    /**
     * w̋[|eVfBNg[w̌f̋[|eVT.  t@CĂȂ. fɂ,
     * ĂĂ悢.
     * 
     * @param element
     *            f
     * @return [|eVt@C̔z; ȂꍇNO_CANDIDATEԂ.
     */
    public static String[] getPPCandidates(String element, String parentDir) {
        String strpp = getDefaultPPDir();
        if (parentDir != null)
            strpp = parentDir;
        File ppDir = new File(strpp);
        if (element == null || element.trim().length() == 0) {
            return new String[] { NO_CANDIDATE };
        }

        if (ppDir == null || !ppDir.isDirectory()) {
            return new String[] { NO_CANDIDATE };
        }

        String[] files = ppDir.list();
        PPOrder[] ppOrder = new PPOrder[files.length];
        for (int i = 0; i < files.length; i++)
            ppOrder[i] = new PPOrder(files[i]);
        Arrays.sort(ppOrder);

        Vector<String> ppfiles = new Vector<String>();
        for (int i = ppOrder.length - 1; i >= 0; i--) {
            String comp = ppOrder[i].ppName.split("_")[0] + "\\d*";
            if (element.matches(comp)) {
                ppfiles.addElement(ppOrder[i].ppName);
            }
        }

        if (ppfiles.size() == 0) {
            return new String[] { NO_CANDIDATE };
        }

        String[] ret = new String[ppfiles.size()];
        ppfiles.copyInto(ret);
        return ret;
    }

    /**
     * ftHg̋[|eVfBNg[w̌f̋[|eVT.  t@CĂȂ. fɂ,
     * ĂĂ悢.
     * 
     * @param element
     *            f
     * @return [|eVt@C̔z; ȂꍇNO_CANDIDATEԂ.
     */
    public static String[] getPPCandidates(String element) {
        return getPPCandidates(element, null);
    }

    /**
     * _uNH[e[VŃpX. Windowsł͂̑s, OSł͂ȂɂIWĩpX̂܂ܕԂ.
     * 
     * @param pathName
     *            IWĩpX.
     * @return spX.
     */
    public static String getPathDQ(String pathName) {
        String osName = ConstParameters.osName;
        String ret = new String();

        if (osName.toLowerCase().trim().startsWith("windows")) {
            ret = "\"" + pathName + "\"";
        } else {
            ret = getPath(pathName);
        }

        return ret;
    }

    /**
     * ΏۂWindowsۂ𖾎IɎw.
     * 
     * @param pathName
     *            IWĩpX
     * @param isWindows
     *            ΏۂWindowsȂ.
     * @return spX.
     */
    public static String getPathDQ(String pathName, boolean isWindows) {
        String osName = ConstParameters.osName;
        String ret = "";
        if (isWindows) {
            ret = "\"" + pathName + "\"";
        } else {
            ret = getPath(pathName);
        }
        return ret;
    }

    /**
     * _uNH[e[Vň͂܂ꂽ̃_uNH[e[VƂ̂.
     * 
     * @param path
     *            _uNH[e[V菜.
     */
    public static String stripDQ(String path) {
        return path.trim().replaceAll("\"", "");
    }

    /**
     * Ƃ镶񂪃_uNH[głĂ邩ǂ
     */
    public static boolean isDoubleQuoted(String foo) {
        return foo.trim().startsWith("\"") && foo.trim().endsWith("\"");
    }

    /**
     * VONH[e[Vň͂܂ꂽ̃VONH[e[VƂ̂.
     * 
     * @param path
     *            VONH[e[V菜.
     */
    public static String stripSQ(String path) {
        return path.trim().replaceAll("\'", "");
    }

    /**
     * e[ũGfB^[~郁\bh. , ҏWm肵ĂȂԂ``save''ȂǂƂꍇł ҏWef.
     * 
     * @param object
     *            JTableł삵Ȃ.
     * @return stopΐ^.
     */
    public static boolean stop(Object object) {
        boolean stopped = false;
        if (object instanceof JTable) {
            TableCellEditor editor = ((JTable) object).getCellEditor();
            try {
                editor.stopCellEditing();
                stopped = true;
            } catch (Exception exc) {
                stopped = false;
            }
        }

        return stopped;
    }

    /**
     * ƂString͐ۂ𒲂ׂ. CharacterNXisDigit\bhgĔ.
     * 
     * @param str
     *            ׂString.
     * @return Ȃΐ^.
     */
    public static boolean isNumber(String str) {
        boolean ret = true;
        if (str == null || str.trim().length() == 0)
            return false;
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; i++) {
            if (!(Character.isDigit(ch[i]))) {
                ret = false;
            }
        }

        return ret;
    }

    /**
     * fBNg[ċAIɏ. java.io.Filedelete()\bhƈႢ, ̉̃t@C
     * 낤Ȃɂ낤SďĂ܂.
     * 
     * @param dir
     *            fBNg[
     */
    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; i++) {
                boolean success = deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
            }
        }

        // The directory is now empty so delete it
        return dir.delete();
    }

    private static String[] defaultIgnoreDir = { ".svn" };

    /**
     * ̉̃fBNg[̐ċAIɒׂ.
     * 
     * @param dir
     *            ΏۂƂȂfBNg[
     * @return fBNg[̐
     */
    public static int getTotalNumDir(File dir) {
        int numdir = 0;
        if (!dir.isDirectory())
            return numdir;
        File[] files = dir.listFiles();
        if (files == null)
            return 1;
        for (int i = 0; i < files.length; i++) {
            if (files[i].getName().equals(".svn"))
                continue;
            if (files[i].isDirectory()) {
                numdir++;
                numdir += getTotalNumDir(files[i]);
            }
        }
        return numdir;
    }

    /**
     * fBNg[ċAIɃRs[
     * 
     * @param fromDir
     * @param toDir
     * @param overwrite
     *            łɂt@C㏑ꍇtrue
     */
    public static boolean copyDir(File fromDir, File toDir, boolean overwrite) {
        if (!fromDir.isDirectory() || !toDir.isDirectory()) {
            logger.debug("both args must be directories");
            return false;
        }
        String fromDirName = fromDir.getName();
        File totoDir = new File(toDir.getAbsolutePath() + FS + fromDirName);
        totoDir.mkdir();
        File[] fromFiles = fromDir.listFiles();
        for (int i = 0; i < fromFiles.length; i++) {
            if (!fromFiles[i].isDirectory()) {
                String name = fromFiles[i].getName();
                String copyName = totoDir.getAbsolutePath() + FS + name;
                if (new File(copyName).exists() && !overwrite)
                    continue;
                try {
                    ExternalProgramExecuter.copyBinary(
                            fromFiles[i].getAbsolutePath(), copyName);
                } catch (Exception exc) {
                    exc.printStackTrace();
                    return false;
                }
            } else {
                boolean ignore = false;
                String name = fromFiles[i].getName();
                for (int j = 0; j < defaultIgnoreDir.length; j++) {
                    if (name.equals(defaultIgnoreDir[j])) {
                        ignore = true;
                    }
                }
                if (!ignore)
                    copyDir(fromFiles[i], totoDir, overwrite);
            }
        }
        return true;
    }

    /**
     * fBNg[ċAIɃRs[
     * 
     * @param fromDir
     * @param toDir
     */
    public static boolean copyDir(File fromDir, File toDir) {
        return copyDir(fromDir, toDir, true);
    }

    /**
     * fBNg[ċAIɃRs[ fromDirl[ꍇg.
     * 
     * @param fromDir
     * @param toDir
     * @param newname
     *            toDir/newnameƂȂ; ̏ꍇ, newname̒gfromDirƓ, ݂Ȋ.
     */
    public static boolean copyDir(File fromDir, File toDir, String newname) {
        if (!fromDir.isDirectory() || !toDir.isDirectory()) {
            logger.debug("both args must be directories");
            return false;
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpfromDir = new File(tmpDir
                + System.getProperty("file.separator") + fromDir.getName());
        deleteDir(tmpfromDir);
        if (!copyDir(fromDir, tmpDir)) {
            return false;
        }

        File toFile = new File(toDir.getAbsolutePath()
                + System.getProperty("file.separator") + newname);
        return tmpfromDir.renameTo(toFile);
    }

    public static void clearTableModel(TableModel model) {
        TableModelListener[] listeners = ((AbstractTableModel) model)
                .getTableModelListeners();
        for (int i = 0; i < listeners.length; i++) {
            model.removeTableModelListener(listeners[i]);
        }

        int row = model.getRowCount();
        int column = model.getColumnCount();
        logger.debug("clearing row, column: " + row + " " + column);

        for (int i = 0; i < row; i++) {
            for (int j = 0; j < column; j++) {
                model.setValueAt("", i, j);
            }
        }
        for (int i = 0; i < listeners.length; i++) {
            model.addTableModelListener(listeners[i]);
        }

    }

    public static void bootPropertyPanel() {
        PropertyPanel pp = new PropertyPanel();
    }

    public static double getNorm(double[] v) {
        double norm = 0.d;
        if (v != null) {
            for (int i = 0; i < v.length; i++) {
                norm += v[i] * v[i];
            }
        } else {
            // logger.error("v was null ... ");
        }
        return Math.sqrt(norm);
    }

    public static void normalize(double[] v) {
        if (v == null) {
            // logger.error("v was null ... ");
        }
        double norm = Utils.getNorm(v);
        for (int i = 0; i < v.length; i++) {
            v[i] = v[i] / norm;
        }
    }

    /**
     * t@C̍s擾
     * 
     * @param fileName
     *            t@C
     * @return t@C̍s(G[-1)
     */
    public static int getNumLines(String fname) {
        int sum = 0;
        BufferedReader br = null;
        try {
            FileReader freader = new FileReader(fname);
            br = new BufferedReader(freader);
            while (br.readLine() != null) {
                sum++;
            }
            br.close();
        } catch (Exception exc) {
            logger.error(exc);
            return -1;
        } finally {
            try {
                br.close();
            } catch (IOException ioe) {
                logger.error(ioe);
                return -1;
            }
        }
        return sum;
    }

    /**
     * eXgpC
     */
    public static void main(String[] args) {
        System.out.println("original path: " + args[0]);
        System.out.println("parsed path: " + Utils.getPath(args[0]));
    }

    /**
     * ꎞt@C擾
     * 
     * @return ꎞt@C
     */
    public static File getTmpFile() {
        String now = String.valueOf(java.util.Calendar.getInstance()
                .getTimeInMillis());
        String tmpDir = System.getProperty("java.io.tmpdir");
        String tmpFile = tmpDir + System.getProperty("file.separator") + "tmp"
                + now;
        return new File(tmpFile);
    }

    /**
     * Windows̏ꍇ, t@CZp[^['\'g. ̂܂܂ƐK\𗘗pƂȂǂɐŝ,
     * GXP[vԂ. backslash݂ȂꍇȂ.
     * 
     * @param path
     *            ̕
     * @return obNXbVGXP[v
     */
    public static String escapeBackSlash(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        Character bs = new Character('\\');
        char[] array = path.toCharArray();
        String ret = "";
        for (int i = 0; i < array.length; i++) {
            ret += String.valueOf(array[i]);
            if (array[i] == '\\') {
                ret += "\\";
            }
        }
        return ret;
    }

    /**
     * z̒̏dvf폜.
     * 
     * @param arg
     *            ̑sz.
     */
    public static Vector removeDupli(Object[] arg) {
        if (arg == null) {
            return null;
        }
        java.util.Arrays.sort(arg);
        Vector vec = new Vector();
        for (int i = 0; i < arg.length; i++) {
            if (vec.indexOf(arg[i]) < 0)
                vec.addElement(arg[i]);
        }
        return vec;
    }

    /**
     * Vector̒̏dvf폜.
     * 
     * @param arg
     *            ̑sz.
     */
    public static Vector removeDupli(Vector vector) {
        if (vector == null || vector.size() == 0)
            return null;
        Object[] objs = new Object[vector.size()];
        vector.copyInto(objs);
        return removeDupli(objs);
    }

    /**
     * ŗ^ꂽt@C當𐶐, Ԃ. sR[h̕ϊȂǂ͈؍sȂ.
     * 
     * @param file
     *            𒊏ot@Cւ̃pX.
     * @return t@C̑Se̕.
     */
    public static String getStringFromFile(String file) {
        String ret = "";
        InputStream in = null;
        Vector vec = new Vector();
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            int b;
            while ((b = in.read()) != -1) {
                vec.addElement(new Byte((byte) b));
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[] by = new byte[vec.size()];

        for (int i = 0; i < vec.size(); i++) {
            by[i] = ((Byte) vec.get(i)).byteValue();
        }

        ret = new String(by);
        return ret;
    }

    /**
     * w̃pXjava.util.Properties̃CX^X𐶐
     * 
     * @param path
     *            ̃pXPropertiesCX^X쐬.
     * @return wPropertiesCX^X; sꍇnullԂ.
     */
    public static Properties getPropertiesFrom(String path) {
        Properties properties = new Properties();
        InputStream inp = null;
        try {
            inp = Utils.class.getResourceAsStream(path);
            properties.load(inp);
        } catch (IOException ioe) {
            logger.error("failed to load property file...");
            return null;
        } finally {
            try {
                if (inp != null) {
                    inp.close();
                }
            } catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return properties;
    }

    /**
     * ̃pX葊΃pX擾.uŏ̈̃fBNg[݂ēԖڂ̈̃fBNg[͂ǂɂ邩v
     * 
     * @param pathFrom
     *            ̃fBNg[猩΃pX
     * @param pathTo
     *            ̃fBNg[ւ̑΃pX
     * @param forwardSlash
     *            ̕ϐtrue̎, pXZp[^[͋'/'g. Windows΍
     */
    public static String getRelativePath(String pathFrom, String pathTo,
            boolean forwardSlash) {
        if (pathFrom == null || pathTo == null) {
            return null;
        }
        String FS = System.getProperty("file.separator");
        if (forwardSlash)
            FS = "/";

        if (new File(pathFrom).equals(new File(pathTo))) {
            return "." + FS;
        }
        String pathFrom_ = pathFrom.trim();
        String pathTo_ = pathTo.trim();
        String filesep = "/";
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            pathFrom_ = pathFrom_.toLowerCase();
            pathTo_ = pathTo_.toLowerCase();
            filesep = "\\\\";
        }
        String[] arfrom = pathFrom_.split(filesep);
        String[] arto = pathTo_.split(filesep);
        if (arfrom.length == 0 || arto.length == 0) {
            return null;
        }
        int leng = arfrom.length;
        if (leng > arto.length) {
            leng = arto.length;
        }
        int commonIndex = leng;
        for (int i = 0; i < leng; i++) {
            if (!arfrom[i].equals(arto[i])) {
                commonIndex = i;
                break;
            }
        }

        String commonPrefix = arfrom[0];
        for (int i = 1; i < commonIndex; i++) {
            commonPrefix += FS + arfrom[i];
        }
        logger.debug("common prefix: " + commonPrefix);
        String suffix = "";
        if (commonPrefix.length() < pathTo.length()) {
            suffix = pathTo.substring(commonPrefix.length() + 1,
                    pathTo.length()).trim();
        }
        String prefix = "";
        if (commonPrefix.length() < pathFrom.length()) {
            String tmp = pathFrom.substring(commonPrefix.length() + 1,
                    pathFrom.length()).trim();
            logger.debug("pathfrom - common: " + tmp);
            String[] array = tmp.split(filesep);
            if (array != null && array.length != 0) {
                for (int i = 0; i < array.length; i++) {
                    if (array[i].trim().length() != 0) {
                        prefix += ".." + FS;
                    }
                }
            }
        }
        return prefix + suffix;
    }

    /**
     * ̃pX葊΃pX擾.uŏ̈̃fBNg[݂ēԖڂ̈̃fBNg[͂ǂɂ邩v
     * 
     * @param pathFrom
     *            ̃fBNg[猩΃pX
     * @param pathTo
     *            ̃fBNg[ւ̑΃pX
     */
    public static String getRelativePath(String pathFrom, String pathTo) {
        return getRelativePath(pathFrom, pathTo, false);
    }

    /**
     * Iy[eBOVXeWindowsۂ𔻒(Windows̏ꍇ͂낢ȋǖʂœȏKv).
     * 
     * @return OSWindowsȏꍇtrue.
     */
    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase()
                .startsWith("windows");
    }

    /**
     * w̃fBNg[̉, w̖Õt@C쐬\ǂ𔻒肷.
     * 
     * @param parentDir
     *            fBNg[. ̉Ƀt@C쐬\ǂ`FbN.
     * @param fname
     *            ̖Õt@C쐬ł邩ǂ`FbN.
     * @return 쐬\, Ǝvꍇtrue.
     */
    public static boolean isCreatable(File parentDir, String fname) {
        if (fname == null || fname.trim().length() == 0)
            return false;
        File[] files = parentDir.listFiles();
        if (files.length == 0)
            return true;
        File testFile = new File(parentDir, fname.trim());
        for (int i = 0; i < files.length; i++)
            if (files[i].equals(testFile))
                return false;
        boolean btest = testFile.mkdir();
        if (!btest)
            return false;

        testFile.delete();
        return true;
    }

    public static int parseJREVersion() {
        String ver = System.getProperty("java.version");
        String vers = ver.substring(0, 5);
        String[] verss = vers.split("\\.");
        String str = "";
        for (int i = 0; i < verss.length; i++)
            str += verss[i];
        return Integer.parseInt(str);
    }

}

/**
 * Ordering of the PP files; prefer nc && us pps compared to paw pps.
 * 
 * @author jkoga
 */
class PPOrder implements Comparable<PPOrder> {
    String ppName = "";

    PPOrder(String ppName) {
        this.ppName = ppName;
    }

    public int compareTo(PPOrder arg0) {
        if (this == arg0)
            return 0;
        PPOrder ppOrder = ((PPOrder) arg0);
        if (ppOrder.ppName.equals(ppName))
            return 0;
        if (ppOrder.ppName.contains("paw") && !this.ppName.contains("paw"))
            return 1;
        if (!ppOrder.ppName.contains("paw") && this.ppName.contains("paw"))
            return -1;
        // return ppName.compareTo(ppOrder.ppName);
        return ppOrder.ppName.compareTo(this.ppName);
    }
}