/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : LineEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LineEditor {

    public static final int NOT_FOUND = -1; /* !< Ɏw̕ȂƂɕԂintl */

    /** the string to be editted */
    private String fullString;

    /** reference to each line */
    private Vector vecLine;

    /** number of lines */
    private int numLines;

    /**
     * GfBbgw肷. Ŏw肵͉sR[hƂɋ敪, X̏Ɏgp.
     * 
     * @param fullString
     *            
     */
    public LineEditor(String fullString) {
        this.fullString = fullString;
        divideIntoLines();
    }

    /**
     * ݒ肷邽߂̃\bh.
     * 
     * @uml.property name="fullString"
     */
    public void setFullString(String fullString) {
        this.fullString = fullString;
        divideIntoLines();
    }

    /**
     * 擾. ̃NXŎ{ꂽҏW f񂪕Ԃ.
     * 
     * @return ̃NXێ镶.
     * 
     * @uml.property name="fullString"
     */
    public String getFullString() {
        fullString = new String();
        for (int i = 0; i < numLines; i++) {
            fullString = fullString + (String) vecLine.get(i)
                    + System.getProperty("line.separator");
        }
        return this.fullString;
    }

    /**
     * Ă镶̍s擾.
     * 
     * @return ̍s.
     * 
     * @uml.property name="numLines"
     */
    public int getNumLines() {
        return this.numLines;
    }

    /** divide into lines */
    private void divideIntoLines() {
        vecLine = new Vector();
        String str;
        StringTokenizer st = new StringTokenizer(fullString,
                System.getProperty("line.separator"));
        numLines = st.countTokens();
        for (int i = 0; i < numLines; i++) {
            vecLine.addElement(st.nextToken());
        }
    }

    /**
     * w̍s̕Ԃ. uw̍sv sꍇnullԂ. ̓Iɂ, index
     * 0菬ꍇ⑍s傫ꍇ.
     * 
     * @param index
     *            sڂ~w肷.
     * @return indexs̃eLXg.
     */
    public String getLine(int index) {
        if (!testIndex(index)) {
            return null;
        }

        return (String) vecLine.get(index);
    }

    /**
     * 猟, Ԃ͂߂ɃqbgsԂ.
     * 
     * @param searchString
     *            .
     * @return s. ȂꍇNOT_FOUNDԂ.
     */
    public int find(String searchString) {
        int i;
        for (i = 0; i < numLines; i++) {
            if (((String) vecLine.get(i)).trim().startsWith(searchString)) {
                break;
            }
        }
        if (i == numLines) {
            return NOT_FOUND;
        }
        return i;
    }

    /**
     * w̍s猟, Ԃ͂߂ɃqbgsԂ.
     * 
     * @param istart
     *            ͂߂s.
     * @param searchString
     *            .
     * @return s. ȂꍇNOT_FOUNDԂ.
     */
    public int find(int istart, String searchString) {
        int i;

        if (istart >= numLines) {
            return NOT_FOUND;
        }

        for (i = istart; i < numLines; i++) {
            if (((String) vecLine.get(i)).trim().startsWith(searchString)) {
                break;
            }
        }

        if (i == numLines) {
            return NOT_FOUND;
        }

        return i;
    }

    /**
     * 猟, Ԃ͂߂ɃqbgsԂ. ̍, case-insensativeȌ.
     * 
     * @param searchString
     *            .
     * @return s. ȂꍇNOT_FOUNDԂ.
     */
    public int findIgnoreCase(String searchString) {
        int i;
        for (i = 0; i < numLines; i++) {
            if (((String) vecLine.get(i)).trim().toLowerCase()
                    .startsWith(searchString.trim().toLowerCase())) {
                break;
            }
        }
        if (i == numLines) {
            return NOT_FOUND;
        }
        return i;
    }

    /**
     * w̍s猟, Ԃ͂߂ɃqbgsԂ. ̍, case-insensativeȌ.
     * 
     * @param istart
     *            ͂߂s.
     * @param searchString
     *            .
     * @return s. ȂꍇNOT_FOUNDԂ.
     */
    public int findIgnoreCase(int istart, String searchString) {
        int i;

        if (!testIndex(istart)) {
            return NOT_FOUND;
        }

        for (i = istart; i < numLines; i++) {
            if (((String) vecLine.get(i)).trim().toLowerCase()
                    .startsWith(searchString.trim().toLowerCase())) {
                break;
            }
        }
        if (i == numLines) {
            return NOT_FOUND;
        }
        return i;
    }

    /**
     * ̒us.
     * 
     * @param index
     *            us.
     * @param replaceString
     *            ue.
     */
    public void replaceLine(int index, String replaceString) {
        if (!testIndex(index)) {
            return;
        }

        vecLine.remove(index);
        vecLine.add(index, replaceString);
        numLines = vecLine.size();
    }

    /**
     * 𑫂.
     * 
     * @param index
     *            s.
     * @param addString
     *            e.
     */
    public void addLine(int index, String addString) {
        if (!testIndex(index)) {
            return;
        }

        vecLine.add(index, addString);
        numLines = vecLine.size();
    }

    /**
     * 폜.
     * 
     * @param index
     *            폜s.
     */
    public void deleteLine(int index) {
        if (!testIndex(index)) {
            return;
        }

        vecLine.remove(index);
        numLines = vecLine.size();
    }

    /** test index */
    private boolean testIndex(int index) {
        if (index >= numLines) {
            return false;
        } else if (index < 0) {
            return false;
        }

        return true;
    }

    /** eXgpC */
    public static void main(String args[]) {
        String str = new String();
        String string = new String();

        try {
            FileReader freader = new FileReader(args[0]);
            BufferedReader breader = new BufferedReader(freader);
            while ((str = breader.readLine()) != null) {
                string = string + str + System.getProperty("line.separator");
            }
            freader.close();
        } catch (IOException e) {
            System.out.println("failed read from file: " + args[0]);
        }

        LineEditor lineeditor = new LineEditor(string);

        for (int i = 0; i < lineeditor.getNumLines(); i++) {
        }
        System.out.println(lineeditor.findIgnoreCase(
                lineeditor.findIgnoreCase("ek_convergence"), "}"));
        System.out.println(lineeditor.findIgnoreCase(args[1]));
    }

}
