/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/13, 20:18
!  AUTHOR(S): KOGA, Junichiro
!  File : ComboBoxChoicesInputInterface.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.ComboBoxChoices;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;

/**
 * InputInterfaceIuWFNg̃GgR{{bNXchoices肷NX.
 * 
 * @author
 */
public class ComboBoxChoicesInputInterface implements ComboBoxChoices {
    private Logger logger = Logger
            .getLogger(ComboBoxChoicesInputInterface.class.getName());

    private InputInterface inputInterface;
    private String type;
    private String tag;

    private String tagbuf;
    private String name;

    private String TABLE = "table";
    private String PRIMITIVE_ENTRY = "primitive_entry";

    /**
     * Creates a new instance of ComboBoxChoicesInputInterface
     * 
     * @param inputInterface
     *            the InputInterface object to which this class is associated.
     * @param type
     *            the type of value (either TABLE or PRIMITIVE_ENTRY
     * @param tag
     *            the input specification, delimited by periods (example:
     *            structure.atom.atom_list).
     */
    public ComboBoxChoicesInputInterface(InputInterface inputInterface,
            String type, String tag) {
        this.inputInterface = inputInterface;
        this.type = type;
        this.tag = tag.trim();

        int last = tag.lastIndexOf(".");
        if (last > 0) {
            tagbuf = tag.copyValueOf(tag.toCharArray(), 0, last);
            name = tag.copyValueOf(tag.toCharArray(), last + 1, tag.length()
                    - last - 1);
            logger.debug("tag & name: " + tagbuf + " " + name);
        } else {
            tagbuf = tag;
            name = tag;
        }
    }

    /**
     * combo box choices are created by examining the values specified in tag.
     * 
     * @return the combobox choices.
     */
    public Object[] getChoices() {
        try {
            int targetIndex = 0;
            inputInterface.selectBlock(tagbuf);
            InputInterfaceTable table = inputInterface.getTable();
            Vector data = table.getTableData();
            InputInterfaceTableColumns[] cols = inputInterface
                    .getInputInterfaceTableSpecManager().getTableSpec(tagbuf)
                    .getTableColumns();
            inputInterface.selectRoot();
            for (int i = 0; i < cols.length; i++) {
                if (cols[i].getName().equals(name)) {
                    targetIndex = i;
                    break;
                }
            }
            String[] ret = new String[data.size()];
            for (int i = 0; i < data.size(); i++) {
                String[] tmp = (String[]) data.elementAt(i);
                ret[i] = tmp[targetIndex];
            }
            return ret;
        } catch (Exception ex) {
            logger.debug("failed to get choices from: " + tag);
            ex.printStackTrace();
        }

        String[] foo = { "" };
        return foo;
    }

    /**
     * don't use this method!
     */
    public Object[] getChoices(int index) {
        return null;
    }

    /**
     * don't use this method!
     */
    public Object[] getChoices(String index) {
        return null;
    }

    public String getToolTipTexts(int index) {
        inputInterface.selectBlock(tagbuf);
        InputInterfaceTable table = inputInterface.getTable();
        Vector data = table.getTableData();
        InputInterfaceTableColumns[] cols = inputInterface
                .getInputInterfaceTableSpecManager().getTableSpec(tagbuf)
                .getTableColumns();

        String[] vals = (String[]) data.elementAt(index);
        if (vals == null || cols == null) {
            return "";
        }

        String foo = cols[0].getName() + "=" + vals[0];
        int num = cols.length;
        if (num > vals.length) {
            num = vals.length;
        }
        for (int i = 1; i < num; i++) {
            foo += ", " + cols[i].getName() + "=" + vals[i];
        }
        return foo;
    }

}
