/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/05, 19:15
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseFileChooser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

import org.apache.log4j.Logger;

import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * JX^JFileChooser. It@C? ƂɈԍŌɎgfBNg[ NfBNg[Ƃ, ݂ȋ@\Ă.
 * NɍŌ̃fBNg[ fBNg[Ƃėp, getSelectedFile()ȂgetSelectedFiles()\bh
 * Ă񂾍ۂɌfBNg[LĂ, ƌ̎dg.
 * 
 * @author
 */
public class ChaseFileChooser extends JFileChooser implements
        ProjectDirBrowserNodeChangeListener, ActionListener {
    private Logger logger = Logger.getLogger(ChaseFileChooser.class.getName());

    /**
     * ɂƂނɕȂɎgp. Ȃ̃RXgN^[ pꍇꂪg.
     */
    public static final String base = "base";

    /** OtplɃf[^荞ގɎgp */
    public static final String graph = "graph";

    /** [|eVt@CIɎgp */
    public static final String pp = "pp";

    /** uqzuvt@CIɎgp */
    public static final String atom = "atom";

    /** 摜t@C⓮t@CIɎgp */
    public static final String media = "media";

    /** Oo͎Ɏgp */
    public static final String log = "log";

    /** pXݒ莞Ɏgp */
    public static final String path = "path";

    /** XNvgt@CIɎgp */
    public static final String script = "script";

    /** ̓t@CIɎgp */
    public static final String input = "input";

    private String type;
    private static GlobalProperties mrud = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_LAST_USED_DIR);

    /**
     * ftHǵut@Cvg.
     */
    public ChaseFileChooser() {
        super();
        this.type = base;
        String initDir = mrud.getProperty(type);
        if (initDir == null) {
            initDir = ".";
        }
        setCurrentDirectory(new File(initDir));
    }

    /**
     * N, It@C? n.
     * 
     * @param type
     *            uIt@Cv
     */
    public ChaseFileChooser(String type) {
        super();
        this.type = type;
        String initDir = mrud.getProperty(type);
        if (initDir == null) {
            initDir = ".";
        }
        setCurrentDirectory(new File(initDir));
    }

    /**
     * ftHǵut@Cvg. , accessoryƂ ProjectDirBrowsert邩ۂIׂ.
     * 
     * @projDirBrowser ProjectDirBrowser\ꍇ^.
     */
    public ChaseFileChooser(boolean projDirBrowser) {
        super();
        if (projDirBrowser) {
            JPanel pac = new JPanel();
            pac.setLayout(new BoxLayout(pac, BoxLayout.Y_AXIS));
            JButton btn = new JButton("to install dir");
            JPanel p = new JPanel();
            p.add(btn);
            pac.add(p);
            pac.add(new ProjectDirBrowser("projects",
                    new ProjectDirBrowserNodeChangeListener[] { this }));
            setAccessory(pac);
            btn.addActionListener(this);
        }
        this.type = base;
        String initDir = mrud.getProperty(type);
        if (initDir == null) {
            initDir = ".";
        }
        setCurrentDirectory(new File(initDir));
    }

    /**
     * N, It@C? n. , accessoryƂ ProjectDirBrowsert邩ۂIׂ.
     * 
     * @param type
     *            uIt@Cv
     * @param projDirBrowser
     *            ProjectDirBrowser\ꍇ^.
     */
    public ChaseFileChooser(String type, boolean projDirBrowser) {
        super();
        if (projDirBrowser) {
            JPanel pac = new JPanel();
            pac.setLayout(new BoxLayout(pac, BoxLayout.Y_AXIS));
            JButton btn = new JButton("to install directory");
            JPanel p = new JPanel();
            p.add(btn);
            pac.add(p);
            pac.add(new ProjectDirBrowser("projects",
                    new ProjectDirBrowserNodeChangeListener[] { this }));
            setAccessory(pac);
            btn.addActionListener(this);
        }
        this.type = type;
        String initDir = mrud.getProperty(type);
        if (initDir == null) {
            initDir = ".";
        }
        setCurrentDirectory(new File(initDir));
    }

    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (file == null) {
            return file;
        }
        String parent;
        if (file.isDirectory()) {
            parent = file.getAbsolutePath();
        } else {
            parent = file.getParent();
        }
        mrud.setProperty(type, parent);
        mrud.storeProperty();
        return file;
    }

    public File[] getSelectedFiles() {
        File[] file = super.getSelectedFiles();
        if (file == null) {
            return null;
        }
        String parent = file[0].getParent();
        if (file[0].isDirectory()) {
            parent = file[0].getAbsolutePath();
        }
        mrud.setProperty(type, parent);
        mrud.storeProperty();
        return file;
    }

    public void nodeSelected(ProjectDirBrowserNodeChangeEvent e) {
        if (e == null || e.getSource() == null) {
            return;
        }
        ProjectDirBrowserNode node = (ProjectDirBrowserNode) e.getSource();
        ProjectInfo proj = node.getProjectInfo();
        setCurrentDirectory(new File(proj.getProjectDirectory()));
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent arg0) {
        File chasedir = new File(System.getProperty("pviewer.home"));
        setCurrentDirectory(chasedir);
    }

    protected int getSelectedFileFilterIndex() {
        int index = 0;
        FileFilter[] filters = getChoosableFileFilters();
        FileFilter currFilter = getFileFilter();
        for (int i = 0; i < filters.length; i++)
            if (filters[i] == currFilter)
                index = i;
        return index;
    }
}
