/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/27, 15:01
!  AUTHOR(S): KOGA, Junichiro
!  File : VRMLExportFileType.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.vrml;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import org.apache.log4j.Logger;
import org.freehep.util.export.ExportFileType;

import ciss.phase_viewer.acviewer.J3DPanel;

/**
 * r[A[VRMLփGNX|[gFileType.
 * 
 * @author
 */
public class VRMLExportFileType extends ExportFileType {
    private Logger logger = Logger
            .getLogger(VRMLExportFileType.class.getName());
    private J3DPanel parent;

    /** Creates a new instance of VRMLExportFileType */
    public VRMLExportFileType(J3DPanel parent) {
        this.parent = parent;
        enableCompression = new JCheckBox("enable gzip compression");
        enableCompression.setSelected(true);
    }

    public void exportToFile(java.io.File file, java.awt.Component[] component,
            java.awt.Component component0, java.util.Properties properties,
            String string) throws java.io.IOException {
    }

    public void exportToFile(java.io.File file, java.awt.Component component,
            java.awt.Component component0, java.util.Properties properties,
            String string) throws java.io.IOException {
        try {
            VRMLExporter exp = new VRMLExporter(parent);
            exp.setGzip(enableCompression.isSelected());
            exp.doExport(file);
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public String[] getMIMETypes() {
        return new String[] { "VRML97" };
    }

    public String[] getExtensions() {
        return new String[] { "wrl", "WRL" };
    }

    public String getDescription() {
        return "VRML97 format";
    }

    public void exportToFile(java.io.OutputStream outputStream,
            java.awt.Component[] component, java.awt.Component component0,
            java.util.Properties properties, String string)
            throws java.io.IOException {
    }

    public void exportToFile(java.io.OutputStream outputStream,
            java.awt.Component component, java.awt.Component component0,
            java.util.Properties properties, String string)
            throws java.io.IOException {
    }

    private JCheckBox enableCompression;

    public javax.swing.JPanel createOptionPanel(java.util.Properties options) {
        javax.swing.JPanel retValue;
        retValue = new JPanel();
        retValue.add(enableCompression);
        return retValue;
    }

    public boolean hasOptionPanel() {
        return true;
    }

}
