/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/26, 14:09
!  AUTHOR(S): KOGA, Junichiro
!  File : EigenValue2VolumetricData.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.fbz;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.VolumetricData;

/**
 * ŗLlf[^VolumeDataIuWFNg쐬.
 * 
 * @author
 */
public class EigenValue2VolumetricData {
    private Logger logger = Logger.getLogger(EigenValue2VolumetricData.class
            .getName());

    private Vector3f[] bvec;
    private Point3f[] kpoints;
    private float[] eigenValues;
    private float[][] delta;
    private int[] ndiv;

    /**
     * Kvȃf[^nRXgN^[. k_ƌŗLl, , ie, 3Ԗڂ̃f[^Ԃ͂₭ς, Ƃ肵悤.
     * 
     * @param bvec
     *            tiqxNg
     * @param kpoints
     *            k_Zbg
     * @param eigenValues
     *            ŗLlZbg; k_̐ƓłKv.
     */
    public EigenValue2VolumetricData(Vector3f[] bvec, Point3f[] kpoints,
            float[] eigenValues) {
        this.bvec = bvec;
        this.kpoints = kpoints;
        this.eigenValues = eigenValues;
        init();
    }

    /* deltavZĂ */
    private void init() {
        delta = new float[3][3];
        float kx0 = kpoints[0].x;
        float ky0 = kpoints[0].y;
        float kz0 = kpoints[0].z;
        float kzdiff = Math.abs(kpoints[0].z - kpoints[1].z);

        //
        // double [] tmp = new double[3];
        // double [][] bmat = new double[3][3];
        // double [][] kmat = new double[3][1];
        // kmat[0][0] = (double) kpoints[0].x;
        // kmat[1][0] = (double) kpoints[0].y;
        // kmat[2][0] = (double) kpoints[0].z;
        // for ( int i=0 ; i<3 ; i++ ) {
        // bmat[0][i] = (double) bvec[i].x;
        // bmat[1][i] = (double) bvec[i].y;
        // bmat[2][i] = (double) bvec[i].z;
        // }
        // Matrix B = new Matrix(bmat);
        // Matrix K = new Matrix(kmat);
        // Matrix S = B.solve(K);
        //
        // for ( int i=0 ; i<3 ; i++ ) {
        // delta[0][i] = (float) S.get(i,0);
        // delta[1][i] = (float) S.get(i,0);
        // delta[2][i] = (float) S.get(i,0);
        // }
        //
        // ndiv = new int[3];
        // ndiv[0] = Math.abs(2 * (int) (kpoints[0].x/delta[0][0]));
        // ndiv[1] = Math.abs(2 * (int) (kpoints[0].y/delta[0][1]));
        // ndiv[2] = Math.abs(2 * (int) (kpoints[0].z/delta[0][2]));
    }

    /**
     * VolumetricDataCX^X
     * 
     * @return k_̍Wx[Xɂ, ŗLlVolumetricData
     */
    public VolumetricData getVolumetricData() {
        VolumetricData ret = new VolumetricData(eigenValues, ndiv, delta,
                new float[] { 0f, 0f, 0f });
        return ret;
    }

}
