/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : BatchFileTokenMarker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.pub.jeditsyntax;

import javax.swing.text.Segment;

/**
 * Batch file token marker.
 * 
 * @author Slava Pestov
 * @version $Id: BatchFileTokenMarker.java,v 1.20 1999/12/13 03:40:29 sp Exp $
 */
public class BatchFileTokenMarker extends TokenMarker {
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        char[] array = line.array;
        int offset = line.offset;
        int lastOffset = offset;
        int length = line.count + offset;

        if (SyntaxUtilities.regionMatches(true, line, offset, "rem")) {
            addToken(line.count, Token.COMMENT1);
            return Token.NULL;
        }

        loop: for (int i = offset; i < length; i++) {
            int i1 = (i + 1);

            switch (token) {
            case Token.NULL:
                switch (array[i]) {
                case '%':
                    addToken(i - lastOffset, token);
                    lastOffset = i;
                    if (length - i <= 3 || array[i + 2] == ' ') {
                        addToken(2, Token.KEYWORD2);
                        i += 2;
                        lastOffset = i;
                    } else
                        token = Token.KEYWORD2;
                    break;
                case '"':
                    addToken(i - lastOffset, token);
                    token = Token.LITERAL1;
                    lastOffset = i;
                    break;
                case ':':
                    if (i == offset) {
                        addToken(line.count, Token.LABEL);
                        lastOffset = length;
                        break loop;
                    }
                    break;
                case ' ':
                    if (lastOffset == offset) {
                        addToken(i - lastOffset, Token.KEYWORD1);
                        lastOffset = i;
                    }
                    break;
                }
                break;
            case Token.KEYWORD2:
                if (array[i] == '%') {
                    addToken(i1 - lastOffset, token);
                    token = Token.NULL;
                    lastOffset = i1;
                }
                break;
            case Token.LITERAL1:
                if (array[i] == '"') {
                    addToken(i1 - lastOffset, token);
                    token = Token.NULL;
                    lastOffset = i1;
                }
                break;
            default:
                throw new InternalError("Invalid state: " + token);
            }
        }

        if (lastOffset != length) {
            if (token != Token.NULL)
                token = Token.INVALID;
            else if (lastOffset == offset)
                token = Token.KEYWORD1;
            addToken(length - lastOffset, token);
        }
        return Token.NULL;
    }

    public boolean supportsMultilineTokens() {
        return false;
    }
}
