/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/27, 18:14
!  AUTHOR(S): KOGA, Junichiro
!  File : CanvasAction.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.prefs;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ACVAction;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropConfigCheckBox;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * 
 * @author
 */
public class CanvasAction extends ACVAction {
    private Logger logger = Logger.getLogger(CanvasAction.class.getName());

    /** Creates a new instance of AxisAction */
    public CanvasAction(BaseJ3DPanel parent) {
        super(parent);
    }

    public void actionPerformed(ActionEvent e) {
        Canvas cv = new Canvas();
        parent.addDisposeOnExit(cv);
    }

    class Canvas extends InternalFrameChase {
        private GlobalProperties props = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

        Canvas() {
            super("use JCanvas3D or not", true, true, true, true,
                    new Dimension(200, 100));
            PropConfigCheckBox cb = new PropConfigCheckBox("use JCanvas3D",
                    "canvas3d_use_jcanvas3d", props);
            getContentPane().setLayout(
                    new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
            getContentPane().add(cb);
            JPanel btnpanel = new JPanel();
            btnpanel.setLayout(new BoxLayout(btnpanel, BoxLayout.X_AXIS));
            JButton appl = new JButton("apply");
            JButton btn = new JButton("dismiss");
            btnpanel.add(appl);
            btnpanel.add(btn);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add(btnpanel, BorderLayout.CENTER);
            getContentPane().add(p);

            appl.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent arg0) {
                    // TODO Auto-generated method stub
                    apply();
                }

            });
            btn.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    // TODO Auto-generated method stub
                    dispose();
                }

            });
        }

        private void apply() {
            props.storeProperty();
        }
    }
}
