/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : WindowMenu.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.settings.PropertiesManager;

class WindowMenu extends JMenu {

    public WindowMenu(String title) {
        super(title);
        init();
    }

    public WindowMenu(String title, int shortcut) {
        super(title);
        setMnemonic(shortcut);
        init();
    }

    /**
     * "lightweight" Ŗ邱Ƃ.
     */
    public WindowMenu(String title, int shortcut, boolean lightWeight) {
        super(title);
        setMnemonic(shortcut);
        this.getPopupMenu().setLightWeightPopupEnabled(lightWeight);
        init();
    }

    private void init() {
        addMenuListener(new MenuListenerWindow(this));
    }

}

class MenuListenerWindow implements MenuListener {

    private static Logger logger = Logger.getLogger(MenuListenerWindow.class
            .getName());

    private JMenu window;

    protected MenuListenerWindow(JMenu window) {
        this.window = window;
    }

    public void menuSelected(MenuEvent e) {
        logger.debug("action performed ...");
        MyJMenuItem foo = new MyJMenuItem("select from projects", KeyEvent.VK_S);
        foo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1,
                KeyEvent.CTRL_MASK + KeyEvent.SHIFT_MASK));
        foo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ChaseGUI.selectFromProjects();
            }
        });
        window.add(foo);
        window.addSeparator();

        JInternalFrame[] frames = Desk.getDesktop().getAllFrames();
        for (int i = 0; i < frames.length; i++) {
            logger.debug("creating menu: " + frames[i].getTitle());
            if (frames[i].isVisible()) {
                WindowMenuItem wmi = new WindowMenuItem(frames[i].getTitle(),
                        frames[i]);
                window.add(wmi);
            }
        }
    }

    public void menuDeselected(MenuEvent e) {
        window.removeAll();
    }

    public void menuCanceled(MenuEvent e) {
        window.removeAll();
    }

}

class WindowMenuItem extends JMenuItem {
    private JInternalFrame frame;

    /**
     * @param title
     *            ̃j[̃^Cg.
     */
    public WindowMenuItem(String title, JInternalFrame frame) {
        super(title);
        this.frame = frame;
        init();
    }

    /**
     * @param title
     *            ̃j[̃^Cg.
     * @param shortcut
     *            zbgL[ݒpintl, ڂJMenuItemAPIQƂ.
     */
    public WindowMenuItem(String title, int shortcut, JInternalFrame frame) {
        super(title);
        this.frame = frame;
        setMnemonic(shortcut);
        init();
    }

    private void init() {
        addActionListener(new ActionListenerWindowMenuItem(frame));
        addMouseListener(new MouseListenerWindowMenuItem(frame));
    }

}

class ActionListenerWindowMenuItem implements ActionListener {
    private static Logger logger = Logger
            .getLogger(ActionListenerWindowMenuItem.class.getName());
    private JInternalFrame frame;

    protected ActionListenerWindowMenuItem(JInternalFrame frame) {
        this.frame = frame;
    }

    public void actionPerformed(ActionEvent e) {
        toggleSelection(frame);
    }

    protected static void toggleSelection(JInternalFrame frame) {
        String toggle = PropertiesManager.getGlobalProperties(
                PropertiesManager.PROPERTIES_PVIEWER).getProperty(
                "check_bounds_window_toggle");
        if (frame.isSelected()) {
            return;
        }
        if (toggle == null || !toggle.trim().equals("false")) {
            ((ChaseFrame) frame).selected(true);
        } else {
            try {
                frame.setSelected(true);
            } catch (java.beans.PropertyVetoException pve) {
                logger.error("couldn't select frame: " + frame.getTitle());
            }
        }
    }

}

class MouseListenerWindowMenuItem implements MouseListener {

    private static Logger logger = Logger
            .getLogger(MouseListenerWindowMenuItem.class.getName());

    private JInternalFrame frame;

    protected MouseListenerWindowMenuItem(JInternalFrame frame) {
        this.frame = frame;
    }

    public void mouseClicked(MouseEvent e) {
        ActionListenerWindowMenuItem.toggleSelection(frame);
    }

    public void mouseEntered(MouseEvent e) {
        ActionListenerWindowMenuItem.toggleSelection(frame);
    }

    public void mouseExited(MouseEvent e) {
        ActionListenerWindowMenuItem.toggleSelection(frame);
    }

    public void mousePressed(MouseEvent e) {
        ActionListenerWindowMenuItem.toggleSelection(frame);
    }

    public void mouseReleased(MouseEvent e) {
    }

}
