/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/02, 17:23
!  AUTHOR(S): KOGA, Junichiro
!  File : FileNameEditPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.file;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * t@CҏWGUI
 * 
 * @author
 */
public class FileNameEditPanel extends InternalFrameChase {
    private Logger logger = Logger.getLogger(FileNameEditPanel.class.getName());
    private ChaseFileManager fileManager;
    private Vector editors = new Vector();

    /** Creates a new instance of FileNameEditPanel */
    public FileNameEditPanel(ChaseFileManager fileManager) {
        super("edit file names for " + fileManager.getName(), true, true, true,
                true, new Dimension(400, 600));
        this.fileManager = fileManager;
        init();
    }

    private void init() {
        Container cont = super.getContentPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.getViewport().setView(createFileEditFrame());
        panel.add(scrollpane);
        panel.add(createButtons());
        cont.add(panel);
        revalidate();
    }

    private JPanel createFileEditFrame() {
        JPanel p = new JPanel();
        ChaseFile[] cfiles = fileManager.getFiles();

        if (cfiles == null || cfiles.length == 0) {
            logger.error("invalid file info.");
            return p;
        }

        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        for (int i = 0; i < cfiles.length; i++) {
            if (cfiles[i].getFileNameEditLevel().equals(ChaseFile.ALWAYS)) {
                // Ȃ炩editor
                FileNameEditor editor = new FileNameEditor(cfiles[i]);
                p.add(editor);
                editors.addElement(editor);
            }
        }

        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
        JButton def = new JButton("set default name");
        JButton save = new JButton("save");
        JButton saveclose = new JButton("save and close");
        JButton close = new JButton("close");
        p.add(def);
        p.add(save);
        p.add(saveclose);
        p.add(close);

        def.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setDefaultName();
            }
        });

        save.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                save();
            }
        });

        saveclose.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                save();
                dispose();
            }
        });

        close.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        Dimension size = new Dimension(getSize().width, 50);
        p.setPreferredSize(size);
        p.setMinimumSize(size);

        return p;
    }

    private void setDefaultName() {
        for (int i = 0; i < editors.size(); i++) {
            ((FileNameEditor) editors.elementAt(i)).setDefaultName();
        }
    }

    private void save() {
        for (int i = 0; i < editors.size(); i++) {
            ((FileNameEditor) editors.elementAt(i)).save();
        }
        fileManager.save();
    }

}

class FileNameEditor extends JPanel {
    private JTextField textField;
    private ChaseFile file;
    private Logger logger = Logger.getLogger(FileNameEditor.class.getName());

    FileNameEditor(ChaseFile file) {
        this.file = file;
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        String ident = file.getIdentifier().getValue();
        this.setBorder(new TitledBorder(ident));

        String name = file.getFileName();
        textField = new JTextField(name);
        add(textField);
        textField.setToolTipText(file.getFileName());
    }

    void save() {
        String newName = textField.getText();
        if (newName != null && newName.trim().length() != 0) {
            file.update("filename", newName);
            file.fileStateChanged();
        } else {
            logger.error("invalid filename!");
            textField.setText(file.getFileName());
        }
    }

    void setDefaultName() {
        textField.setText(file.getDefaultName().getDefault());
    }

}
