/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/14, 19:10
!  AUTHOR(S): KOGA, Junichiro
!  File : WSCellRealSpace.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.media.j3d.Node;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.acviewer.scenegraphelements.CellObject;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * ԂWigner-SeitzE\邽߂GUI.
 * 
 * @author
 */
public class WSCellRealSpace extends InternalFrameChase {
    private Logger logger = Logger.getLogger(WSCellRealSpace.class.getName());
    private CoordsViewerInterface parent;

    /** Creates a new instance of WSCellRealSpace */
    public WSCellRealSpace(MainPanel parent) {
        super("draw Wigner-Seitz cell", new Dimension(500, 340));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        init();
        setVisible(true);
    }

    private WSCellAttrEditor wsattreditor;
    private WignerSeitzAttributes wsattrs;
    private WignerSeitzCell wscell;
    private CellObject cellObject;

    private void init() {
        TGAtom tgat = (TGAtom) parent.getScene().getTGAtom();
        Node[] nd = tgat.getChildren(CellObject.class);
        if (nd != null && nd.length != 0) {
            cellObject = ((CellObject) nd[0]);
            wscell = cellObject.getWSCell();
            if (wscell != null) {
                wsattrs = wscell.getAttributes();
            } else {
                wsattrs = new WignerSeitzAttributes();
                wsattrs.isReciprocalSpace = false;
            }
        } else {
            logger.info("cell must be shown.");
            dispose();
            return;
        }
        wsattreditor = new WSCellAttrEditor(wsattrs);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, BoxLayout.X_AXIS));
        JButton apply = new JButton("apply");
        JButton delete = new JButton("delete");
        JButton dismiss = new JButton("dismiss");
        btnPanel.add(apply);
        btnPanel.add(delete);
        btnPanel.add(dismiss);

        Container container = getContentPane();
        container.setLayout(new BoxLayout(container, BoxLayout.Y_AXIS));
        container.add(wsattreditor);
        container.add(btnPanel);

        apply.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                doApply();
            }
        });

        delete.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                doDelete();
            }
        });

        dismiss.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
    }

    private void doApply() {
        wsattreditor.doIt();
        if (wscell == null) {
            cellObject.createWSCell();
            wscell = cellObject.getWSCell();
            return;
        }
        wscell.recreate();
    }

    private void doDelete() {
        if (wscell == null) {
            return;
        }
        wscell.detach();
        wscell = null;
        cellObject.nullifyWSCell();
    }

}
