/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/23, 15:06
!  AUTHOR(S): KOGA, Junichiro
!  File : PreparationPanelBase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.input.InputCheckerGUI;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.UndoRedoEvent;
import ciss.phase_viewer.inputinterface.UndoRedoListener;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.TabbedProjectManipulator;

/**
 * PHASEۂ̓t@CdlvO"PreparationPanel"̃x[XƂȂ郆[eBeB[NX
 * 
 * @author
 */
public abstract class PreparationPanelBase extends ProjectManipulator implements
        UndoRedoListener {
    private Logger logger = Logger.getLogger(PreparationPanelBase.class
            .getName());

    protected InputInterface inputInterface;

    /** Creates a new instance of PreparationPanelBase */
    public PreparationPanelBase(ProjectInfo projectInfo) {
        super(projectInfo);
        initComponents();
    }

    /**
     * "PreparationPanel"̎ׂplȂǂw肷XMLt@CԂ悤Ɏ
     */
    protected abstract java.net.URL getTabbedManipulatorSpec();

    public void init() {
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        inputInterface = projectInfo.getInputInterface();
        java.net.URL urltab = getTabbedManipulatorSpec();
        add(new TabbedProjectManipulator(urltab, projectInfo));
        add(createButtons());
    }

    private JButton btnSave;

    private JButton btnUndo;

    private JButton btnRedo;

    private JButton btnCheck;

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
        btnSave = new JButton("save");
        btnUndo = new JButton("undo");
        btnRedo = new JButton("redo");
        JButton btnEdit = new JButton("editor");
        btnUndo.setEnabled(false);
        btnRedo.setEnabled(false);
        p.add(btnEdit);
        p.add(btnSave);
        p.add(btnUndo);

        /*
         * if (getInputCheckerProps() != null) { btnCheck = new
         * JButton("check input"); // p.add(btnCheck);
         * btnCheck.addActionListener(new ActionListener() { public void
         * actionPerformed(ActionEvent e) { bootInputChecker(); } }); }
         */

        // uredov͂Ɠ. yfBO.
        // p.add(btnRedo);

        inputInterface.addUndoRedoListener(this);

        btnEdit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String nfinp = projectInfo.getProjectDirectory()
                        + System.getProperty("file.separator")
                        + projectInfo.getChaseFileManager().getFile("F_INP")
                                .getFileName();
                ProjectBrowserUtils.bootTextViewer(nfinp);
            }
        });

        btnSave.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String nfinp = projectInfo.getProjectDirectory()
                        + System.getProperty("file.separator")
                        + projectInfo.getChaseFileManager().getFile("F_INP")
                                .getFileName();
                inputInterface.saveTo(new java.io.File(nfinp));
                projectInfo.getChaseFileManager().save();
            }
        });

        btnUndo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                inputInterface.undo();
            }
        });

        // btnRedo.addActionListener(new ActionListener() {
        // public void actionPerformed(ActionEvent e) {
        // inputInterface.redo();
        // }
        // });

        return p;
    }

    private void bootInputChecker() {
        InputCheckerGUI gui = new InputCheckerGUI(getInputCheckerProps(),
                projectInfo.getInputInterface());
    }

    protected abstract Properties getInputCheckerProps();

    public void undoRedoStateChanged(UndoRedoEvent e) {
        logger.debug("at undoRedoStateChanged: size of undostack, redostack: "
                + e.getUndoStackCount() + " " + e.getRedoStackCount());
        logger.debug("source: " + e.getSource());
        btnUndo.setEnabled(e.getUndoStackCount() != 0);
        btnRedo.setEnabled(e.getRedoStackCount() != 0);
    }

    public boolean postProcess() {
        if (!inputInterface.stateChanged() || projectInfo.getParent() == null
                || !projectInfo.getParent().isVisible()) {
            return true;
        }
        int res = JOptionPane.showOptionDialog(this,
                "modified buffer exists... exit without saving?",
                "confirmation", JOptionPane.YES_NO_CANCEL_OPTION,
                JOptionPane.INFORMATION_MESSAGE, null, new String[] { "yes",
                        "no", "save" }, "save");
        if (res == JOptionPane.YES_OPTION) {
            inputInterface.setState(false);
            return true;
        }

        if (res == JOptionPane.NO_OPTION) {
            return false;
        }

        if (res == JOptionPane.CANCEL_OPTION) {
            inputInterface.save();
            return true;
        }

        return true;
    }

    public void initializeProject() {
    }

    private void initComponents() {
        jPanel5 = new javax.swing.JPanel();

        setLayout(new java.awt.GridLayout(1, 0));
        setBorder(new javax.swing.border.TitledBorder(null,
                "Preparation panel",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS Sans Serif", 0, 11), new java.awt.Color(
                        0, 0, 102)));
    }

    private javax.swing.JPanel jPanel5;
}
