/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/09, 15:06
!  AUTHOR(S): KOGA, Junichiro
!  File : FileState.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.inputinterface.filestate;

import java.io.File;

import org.apache.log4j.Logger;

/**
 * t@C̏Ԃ\NX
 * 
 * @author
 */
public class FileState {
    /**
     * Yt@Cɂ͓ɂȂɂωȂꍇw
     */
    public static int FILE_NO_CHANGE = 0;
    /**
     * Yt@Cꂽꍇw
     */
    public static int FILE_CREATED = 1;
    /**
     * Yt@C폜Ăꍇw
     */
    public static int FILE_REMOVED = 2;
    /**
     * Yt@CҏWꂽꍇw
     */
    public static int FILE_MODIFIED = 3;

    private Logger logger = Logger.getLogger(FileState.class.getName());

    private int fileState = FILE_NO_CHANGE;
    private File file;

    /**
     * Ήt@Cw.
     * 
     * @param file
     *            Ήt@C
     */
    public FileState(File file) {
        this.file = file;
    }

    /**
     * t@CԂƑΉt@Cw肷.
     * 
     * @param file
     *            Ήt@C
     * @param fileState
     *            Ήt@C̏
     */
    public FileState(File file, int fileState) {
        this.file = file;
        this.fileState = fileState;
    }

    /**
     * ̃t@C̏Ԃ擾
     * 
     * @return Yt@C̏
     */
    public int getFileState() {
        return this.fileState;
    }

    /**
     * ̃IuWFNgɊ֘Atꂽt@Ĉ̂Ԃ.
     * 
     * @return ̃NXɊ֘Atꂽt@C
     */
    public File getFile() {
        return this.file;
    }

    /**
     * ̃NXɊ֘AtĂFileIuWFNglastModified\bhĂ
     * (getFile().lastModified()Ɠ)
     * 
     * @return ̃NXɊ֘AtĂt@C̍XV
     */
    public long lastModified() {
        return this.file.lastModified();
    }

    /**
     * ̃IuWFNg̎Ăut@Cvǂ𔻒肷
     * 
     * @param obj
     *            rFileStateIuWFNg
     * @return t@CwĂꍇtrue
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof FileState)) {
            return false;
        }
        FileState state = (FileState) obj;
        return state.getFile().equals(file);
    }

    public String toString() {
        String ret = "file : " + file.getAbsolutePath();
        if (fileState == FILE_REMOVED) {
            ret += " state: removed";
        }
        if (fileState == FILE_CREATED) {
            ret += " state: created";
        }
        if (fileState == FILE_MODIFIED) {
            ret += " state: modified";
        }
        return ret;
    }
}
