/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/11, 11:50
!  AUTHOR(S): KOGA, Junichiro
!  File : ACVData.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer;

import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;

/**
 * qzur[A[KvƂf[^bvNX.
 * 
 * @author
 */
public class ACVData {
    private Logger logger = Logger.getLogger(ACVData.class.getName());
    private ACVCaller caller;
    private Vector frames;
    private String parentDir;
    private InputInterface inputInterface;
    private String tag;

    private String fileName = "";

    private BravaisLattice bravaisLattice;

    /**
     * @param caller
     *            ACVieweŕuĂяov܂nullł悢.
     * @param frames
     *            t[񂪊i[ꂽVector. AtomCoordsIuWFNg܂ĂԂƂȂĂ͂.
     * @param parentDir
     *            ĂяõfBNg[
     * @param inputInterface
     *            InputInterfaceIuWFNg. ɃJ擾̂Ɏgp. null̏ꍇɃftHg.
     * @param tag
     *            Jw肷̂Ɏgp. ftHg𗘗pꍇnulln.
     */
    public ACVData(ACVCaller caller, Vector frames, String parentDir,
            InputInterface inputInterface, String tag) {
        this.caller = caller;
        this.frames = frames;
        this.parentDir = parentDir;
        this.inputInterface = inputInterface;
        this.tag = tag;
    }

    /**
     * @param caller
     *            ACVieweŕuĂяov܂nullł悢.
     * @param frames
     *            t[񂪊i[ꂽVector. AtomCoordsIuWFNg܂ĂԂƂȂĂ͂.
     * @param parentDir
     *            ĂяõfBNg[
     * @param inputInterface
     *            InputInterfaceIuWFNg. ɃJ擾̂Ɏgp. null̏ꍇɃftHg.
     * @param tag
     *            Jw肷̂Ɏgp. ftHg𗘗pꍇnulln.
     */
    public ACVData(ACVCaller caller, AtomCoords[] coords, String parentDir,
            InputInterface inputInterface, String tag) {
        this.caller = caller;
        this.frames = new Vector();
        if (coords != null && coords.length != 0) {
            for (int i = 0; i < coords.length; i++) {
                frames.addElement(coords[i]);
            }
        }
        this.parentDir = parentDir;
        this.inputInterface = inputInterface;
        this.tag = tag;
    }

    /**
     * `悵̃ux[iqݒ; null̏ꍇPrimitiveƉ肷.
     * 
     * @param bravaisLattice
     */
    public void setBravaisLattice(BravaisLattice bravaisLattice) {
        this.bravaisLattice = bravaisLattice;
    }

    /**
     * `悵̃ux[iq擾; null̏ꍇPrimitiveƌ.
     * 
     * @return `悵f[^̃ux[iq
     */
    public BravaisLattice getBravaisLattice() {
        return this.bravaisLattice;
    }

    public String getParentDir() {
        return this.parentDir;
    }

    public String getTag() {
        return this.tag;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return fileName;
    }

    public InputInterface getInputInterface() {
        if (inputInterface == null) {
            DataManager dm = new DataManager("foo", PhaseConstants.TABLESPEC,
                    false);
            dm.parse();
        }
        return this.inputInterface;
    }

    public InputInterfaceTableColumns[] getTableColums() {
        if (tag == null) {
            tag = StringConstants.phase_atom_tag;
        }
        return inputInterface.getInputInterfaceTableSpecManager()
                .getTableSpec(tag).getTableColumns();
    }

    public Vector getFrames() {
        return this.frames;
    }

    public AtomCoords getFirstFrame() {
        return (AtomCoords) frames.elementAt(0);
    }

    public ACVCaller getCaller() {
        return caller;
    }

}
