/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MatrixInversionException;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnPrint;

class MnAlgebraicSymMatrix {
    private int theSize;
    private int theNRow;
    private double[] theData;

    MnAlgebraicSymMatrix(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid matrix size: " + n);
        }
        this.theSize = n * (n + 1) / 2;
        this.theNRow = n;
        this.theData = new double[this.theSize];
    }

    void invert() throws MatrixInversionException {
        if (this.theSize == 1) {
            double tmp = this.theData[0];
            if (tmp <= 0.0) {
                throw new MatrixInversionException();
            }
            this.theData[0] = 1.0 / tmp;
        } else {
            int i;
            int nrow = this.theNRow;
            double[] s = new double[nrow];
            double[] q = new double[nrow];
            double[] pp = new double[nrow];
            for (i = 0; i < nrow; ++i) {
                double si = this.theData[this.theIndex(i, i)];
                if (si < 0.0) {
                    throw new MatrixInversionException();
                }
                s[i] = 1.0 / Math.sqrt(si);
            }
            for (i = 0; i < nrow; ++i) {
                for (int j = i; j < nrow; ++j) {
                    int n = this.theIndex(i, j);
                    this.theData[n] = this.theData[n] * (s[i] * s[j]);
                }
            }
            for (i = 0; i < nrow; ++i) {
                int index;
                int j;
                int k = i;
                if (this.theData[this.theIndex(k, k)] == 0.0) {
                    throw new MatrixInversionException();
                }
                q[k] = 1.0 / this.theData[this.theIndex(k, k)];
                pp[k] = 1.0;
                this.theData[this.theIndex((int)k, (int)k)] = 0.0;
                int kp1 = k + 1;
                if (k != 0) {
                    for (j = 0; j < k; ++j) {
                        index = this.theIndex(j, k);
                        pp[j] = this.theData[index];
                        q[j] = this.theData[index] * q[k];
                        this.theData[index] = 0.0;
                    }
                }
                if (k != nrow - 1) {
                    for (j = kp1; j < nrow; ++j) {
                        index = this.theIndex(k, j);
                        pp[j] = this.theData[index];
                        q[j] = -this.theData[index] * q[k];
                        this.theData[index] = 0.0;
                    }
                }
                for (j = 0; j < nrow; ++j) {
                    for (k = j; k < nrow; ++k) {
                        int n = this.theIndex(j, k);
                        this.theData[n] = this.theData[n] + pp[j] * q[k];
                    }
                }
            }
            for (int j = 0; j < nrow; ++j) {
                for (int k = j; k < nrow; ++k) {
                    int n = this.theIndex(j, k);
                    this.theData[n] = this.theData[n] * (s[j] * s[k]);
                }
            }
        }
    }

    protected Object clone() {
        MnAlgebraicSymMatrix copy = new MnAlgebraicSymMatrix(this.theNRow);
        System.arraycopy(this.theData, 0, copy.theData, 0, this.theSize);
        return copy;
    }

    MnAlgebraicVector eigenvalues() {
        int nrow = this.theNRow;
        double[] tmp = new double[(nrow + 1) * (nrow + 1)];
        double[] work = new double[1 + 2 * nrow];
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j <= i; ++j) {
                tmp[1 + i + (1 + j) * nrow] = this.get(i, j);
                tmp[(1 + i) * nrow + (1 + j)] = this.get(i, j);
            }
        }
        int info = MnAlgebraicSymMatrix.mneigen(tmp, nrow, nrow, work.length, work, 1.0E-6);
        if (info != 0) {
            throw new EigenvaluesException();
        }
        MnAlgebraicVector result = new MnAlgebraicVector(nrow);
        for (int i = 0; i < nrow; ++i) {
            result.set(i, work[1 + i]);
        }
        return result;
    }

    private int theIndex(int row, int col) {
        if (row > col) {
            return col + row * (row + 1) / 2;
        }
        return row + col * (col + 1) / 2;
    }

    double get(int row, int col) {
        if (row >= this.theNRow || col >= this.theNRow) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.theData[this.theIndex(row, col)];
    }

    void set(int row, int col, double value) {
        if (row >= this.theNRow || col >= this.theNRow) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.theData[this.theIndex((int)row, (int)col)] = value;
    }

    double[] data() {
        return this.theData;
    }

    int size() {
        return this.theSize;
    }

    int nrow() {
        return this.theNRow;
    }

    int ncol() {
        return this.nrow();
    }

    public String toString() {
        return MnPrint.toString(this);
    }

    private static int mneigen(double[] a, int ndima, int n, int mits, double[] work, double precis) {
        double pt;
        int i__3;
        int j;
        double h__;
        int k;
        int i__2;
        double gl;
        double f;
        int l;
        int i1;
        int m = 0;
        int a_dim1 = ndima;
        int a_offset = 1 + a_dim1 * 1;
        int ifault = 1;
        int i__ = n;
        int i__1 = n;
        for (i1 = 2; i1 <= i__1; ++i1) {
            l = i__ - 2;
            f = a[i__ + (i__ - 1) * a_dim1];
            gl = 0.0;
            if (l >= 1) {
                i__2 = l;
                for (k = 1; k <= i__2; ++k) {
                    double r__1 = a[i__ + k * a_dim1];
                    gl += r__1 * r__1;
                }
            }
            h__ = gl + f * f;
            if (gl <= 1.0E-35) {
                work[i__] = 0.0;
                work[n + i__] = f;
            } else {
                ++l;
                gl = Math.sqrt(h__);
                if (f >= 0.0) {
                    gl = -gl;
                }
                work[n + i__] = gl;
                h__ -= f * gl;
                a[i__ + (i__ - 1) * a_dim1] = f - gl;
                f = 0.0;
                i__2 = l;
                for (j = 1; j <= i__2; ++j) {
                    a[j + i__ * a_dim1] = a[i__ + j * a_dim1] / h__;
                    gl = 0.0;
                    i__3 = j;
                    for (k = 1; k <= i__3; ++k) {
                        gl += a[j + k * a_dim1] * a[i__ + k * a_dim1];
                    }
                    if (j < l) {
                        int j1 = j + 1;
                        i__3 = l;
                        for (k = j1; k <= i__3; ++k) {
                            gl += a[k + j * a_dim1] * a[i__ + k * a_dim1];
                        }
                    }
                    work[n + j] = gl / h__;
                    f += gl * a[j + i__ * a_dim1];
                }
                double hh = f / (h__ + h__);
                i__2 = l;
                for (j = 1; j <= i__2; ++j) {
                    f = a[i__ + j * a_dim1];
                    work[n + j] = gl = work[n + j] - hh * f;
                    i__3 = j;
                    for (k = 1; k <= i__3; ++k) {
                        a[j + k * a_dim1] = a[j + k * a_dim1] - f * work[n + k] - gl * a[i__ + k * a_dim1];
                    }
                }
                work[i__] = h__;
            }
            --i__;
        }
        work[1] = 0.0;
        work[n + 1] = 0.0;
        i__1 = n;
        for (i__ = 1; i__ <= i__1; ++i__) {
            l = i__ - 1;
            if (work[i__] != 0.0 && l != 0) {
                i__3 = l;
                for (j = 1; j <= i__3; ++j) {
                    gl = 0.0;
                    i__2 = l;
                    for (k = 1; k <= i__2; ++k) {
                        gl += a[i__ + k * a_dim1] * a[k + j * a_dim1];
                    }
                    i__2 = l;
                    for (k = 1; k <= i__2; ++k) {
                        int n2 = k + j * a_dim1;
                        a[n2] = a[n2] - gl * a[k + i__ * a_dim1];
                    }
                }
            }
            work[i__] = a[i__ + i__ * a_dim1];
            a[i__ + i__ * a_dim1] = 1.0;
            if (l == 0) continue;
            i__2 = l;
            for (j = 1; j <= i__2; ++j) {
                a[i__ + j * a_dim1] = 0.0;
                a[j + i__ * a_dim1] = 0.0;
            }
        }
        int n1 = n - 1;
        i__1 = n;
        for (i__ = 2; i__ <= i__1; ++i__) {
            int i0 = n + i__ - 1;
            work[i0] = work[i0 + 1];
        }
        work[n + n] = 0.0;
        double b = 0.0;
        f = 0.0;
        i__1 = n;
        l = 1;
        while (l <= i__1) {
            j = 0;
            h__ = precis * (Math.abs(work[l]) + Math.abs(work[n + l]));
            if (b < h__) {
                b = h__;
            }
            i__2 = n;
            int m1 = l;
            while (m1 <= i__2 && !(Math.abs(work[n + (m = m1++)]) <= b)) {
            }
            if (m != l) {
                do {
                    if (j == mits) {
                        return ifault;
                    }
                    ++j;
                    pt = (work[l + 1] - work[l]) / (work[n + l] * 2.0);
                    double r__ = Math.sqrt(pt * pt + 1.0);
                    double pr = pt + r__;
                    if (pt < 0.0) {
                        pr = pt - r__;
                    }
                    h__ = work[l] - work[n + l] / pr;
                    i__2 = n;
                    i__ = l;
                    while (i__ <= i__2) {
                        int n3 = i__++;
                        work[n3] = work[n3] - h__;
                    }
                    f += h__;
                    pt = work[m];
                    double c__ = 1.0;
                    double s = 0.0;
                    m1 = m - 1;
                    i__ = m;
                    i__2 = m1;
                    for (i1 = l; i1 <= i__2; ++i1) {
                        j = i__--;
                        gl = c__ * work[n + i__];
                        h__ = c__ * pt;
                        if (Math.abs(pt) < Math.abs(work[n + i__])) {
                            c__ = pt / work[n + i__];
                            r__ = Math.sqrt(c__ * c__ + 1.0);
                            work[n + j] = s * work[n + i__] * r__;
                            s = 1.0 / r__;
                            c__ /= r__;
                        } else {
                            c__ = work[n + i__] / pt;
                            r__ = Math.sqrt(c__ * c__ + 1.0);
                            work[n + j] = s * pt * r__;
                            s = c__ / r__;
                            c__ = 1.0 / r__;
                        }
                        pt = c__ * work[i__] - s * gl;
                        work[j] = h__ + s * (c__ * gl + s * work[i__]);
                        i__3 = n;
                        for (k = 1; k <= i__3; ++k) {
                            h__ = a[k + j * a_dim1];
                            a[k + j * a_dim1] = s * a[k + i__ * a_dim1] + c__ * h__;
                            a[k + i__ * a_dim1] = c__ * a[k + i__ * a_dim1] - s * h__;
                        }
                    }
                    work[n + l] = s * pt;
                    work[l] = c__ * pt;
                } while (!(Math.abs(work[n + l]) <= b));
            }
            int n4 = l++;
            work[n4] = work[n4] + f;
        }
        i__1 = n1;
        for (i__ = 1; i__ <= i__1; ++i__) {
            k = i__;
            pt = work[i__];
            i1 = i__ + 1;
            i__3 = n;
            for (j = i1; j <= i__3; ++j) {
                if (!(work[j] < pt)) continue;
                k = j;
                pt = work[j];
            }
            if (k == i__) continue;
            work[k] = work[i__];
            work[i__] = pt;
            i__3 = n;
            for (j = 1; j <= i__3; ++j) {
                pt = a[j + i__ * a_dim1];
                a[j + i__ * a_dim1] = a[j + k * a_dim1];
                a[j + k * a_dim1] = pt;
            }
        }
        ifault = 0;
        return ifault;
    }

    private class EigenvaluesException
    extends RuntimeException {
        private EigenvaluesException() {
        }
    }
}

