/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FCNGradientBase;
import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnUserTransformation;

class AnalyticalGradientCalculator
implements GradientCalculator {
    private FCNGradientBase theGradCalc;
    private MnUserTransformation theTransformation;
    private boolean theCheckGradient;

    AnalyticalGradientCalculator(FCNGradientBase fcn, MnUserTransformation state, boolean checkGradient) {
        this.theGradCalc = fcn;
        this.theTransformation = state;
        this.theCheckGradient = checkGradient;
    }

    public FunctionGradient gradient(MinimumParameters par) {
        double[] grad = this.theGradCalc.gradient(this.theTransformation.transform(par.vec()).data());
        if (grad.length != this.theTransformation.parameters().size()) {
            throw new IllegalArgumentException("Invalid parameter size");
        }
        MnAlgebraicVector v = new MnAlgebraicVector(par.vec().size());
        for (int i = 0; i < par.vec().size(); ++i) {
            int ext = this.theTransformation.extOfInt(i);
            if (this.theTransformation.parameter(ext).hasLimits()) {
                double dd = this.theTransformation.dInt2Ext(i, par.vec().get(i));
                v.set(i, dd * grad[ext]);
                continue;
            }
            v.set(i, grad[ext]);
        }
        return new FunctionGradient(v);
    }

    public FunctionGradient gradient(MinimumParameters par, FunctionGradient grad) {
        return this.gradient(par);
    }

    boolean checkGradient() {
        return this.theCheckGradient;
    }
}

