/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.test.MemoryDataSource;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;

public class TestJASHistReconnect
extends MemoryDataSource {
    public String getTitle() {
        return "Java Memory Usage TIMES TWO";
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        double[][] dArray = super.rebin(n, d, d2, bl, bl2);
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < dArray2.length; ++j) {
                dArray2[j] = dArray2[j] * 2.0;
            }
        }
        return dArray;
    }

    static void printDB(JComponent jComponent) {
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        boolean bl = repaintManager.isDoubleBufferingEnabled();
        boolean bl2 = jComponent.isDoubleBuffered();
        System.out.println("Double-Buffered:  manager=" + bl + ",  component=" + bl2);
    }

    public static void main(String[] stringArray) throws Exception {
        final JASHist jASHist = new JASHist();
        TestJASHistReconnect.printDB(jASHist);
        JASHistData jASHistData = jASHist.addData(new MemoryDataSource());
        jASHist.setTitle("Java Memory Usage");
        jASHist.setDataAreaBorderType(3);
        jASHist.getYAxis().setLabel("MBytes");
        jASHist.getXAxis().setLabel("Time (seconds)");
        jASHist.setAllowUserInteraction(true);
        jASHist.setShowLegend(0);
        TestJASHistReconnect.printDB(jASHist);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1010L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    TestJASHistReconnect.printDB(jASHist);
                }
            }
        });
        thread.start();
        int n = 0;
        while (n == 0) {
            JOptionPane.showConfirmDialog(null, jASHist, "Plot Dialog", -1);
            n = JOptionPane.showConfirmDialog(null, "Show Plot again ...", " Question Dialog", 2);
        }
        System.exit(0);
    }
}

