/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyBuiltinFunctionSet
extends PyObject
implements Cloneable {
    public PyObject __name__;
    public PyObject __doc__;
    public PyObject __self__;
    public static PyObject __members__;
    protected String name;
    protected int minargs;
    protected int maxargs;
    protected boolean isMethod;
    protected int index;
    protected String doc;

    public PyBuiltinFunctionSet(String name, int index, int minargs, int maxargs, boolean isMethod, String doc) {
        this.name = name;
        this.index = index;
        this.minargs = minargs;
        this.maxargs = maxargs;
        this.isMethod = isMethod;
        this.doc = doc;
        this.__name__ = new PyString(name);
        this.__doc__ = doc == null ? Py.None : new PyString(doc);
        this.__self__ = Py.None;
    }

    public PyObject _doget(PyObject container) {
        return this._doget(container, null);
    }

    public PyObject _doget(PyObject container, PyObject wherefound) {
        if (this.isMethod && this.__self__ == Py.None) {
            try {
                PyBuiltinFunctionSet unique = (PyBuiltinFunctionSet)this.clone();
                unique.__self__ = container;
                return unique;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return this;
    }

    public String toString() {
        if (this.isMethod) {
            return "<built-in method " + this.name + ">";
        }
        return "<built-in function " + this.name + ">";
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isNumberType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    public PyException argCountError(int nargs) {
        if (this.minargs == this.maxargs) {
            return Py.TypeError(this.name + "(): expected " + this.minargs + " args; got " + nargs);
        }
        return Py.TypeError(this.name + "(): expected " + this.minargs + "-" + this.maxargs + " args; got " + nargs);
    }

    public PyObject fancyCall(PyObject[] args) {
        throw Py.TypeError("surprising call");
    }

    public PyObject __call__(PyObject[] args) {
        int nargs = args.length;
        if (this.minargs != -1 && (nargs > this.maxargs || nargs < this.minargs)) {
            throw this.argCountError(nargs);
        }
        switch (nargs) {
            case 0: {
                return this.__call__();
            }
            case 1: {
                return this.__call__(args[0]);
            }
            case 2: {
                return this.__call__(args[0], args[1]);
            }
            case 3: {
                return this.__call__(args[0], args[1], args[2]);
            }
            case 4: {
                return this.__call__(args[0], args[1], args[2], args[3]);
            }
        }
        return this.fancyCall(args);
    }

    public PyObject __call__(PyObject[] args, String[] kws) {
        if (kws.length != 0) {
            throw Py.TypeError(this.name + "(): this function takes no keyword arguments");
        }
        return this.__call__(args);
    }

    public PyObject __call__() {
        throw this.argCountError(0);
    }

    public PyObject __call__(PyObject arg1) {
        throw this.argCountError(1);
    }

    public PyObject __call__(PyObject arg1, PyObject arg2) {
        throw this.argCountError(2);
    }

    public PyObject __call__(PyObject arg1, PyObject arg2, PyObject arg3) {
        throw this.argCountError(3);
    }

    public PyObject __call__(PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4) {
        throw this.argCountError(4);
    }

    static {
        PyObject[] members = new PyString[]{new PyString("__doc__"), new PyString("__name__"), new PyString("__self__")};
        __members__ = new PyList(members);
    }
}

