/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.HasName;
import hep.aida.ref.pdf.HasUnits;
import hep.aida.ref.pdf.HasValue;
import hep.aida.ref.pdf.Units;
import hep.aida.ref.pdf.VariableListener;
import java.util.ArrayList;
import org.freehep.util.Value;

public abstract class Variable
implements HasName,
HasValue,
HasUnits {
    public static int FUNCTION = 0;
    public static int DEPENDENT = 1;
    public static int PARAMETER = 2;
    static int NAME_CHANGING = 0;
    static int NAME_CHANGED = 1;
    static int UNITS_CHANGING = 2;
    static int UNITS_CHANGED = 3;
    static int VALUE_CHANGING = 4;
    static int VALUE_CHANGED = 5;
    static int RANGE_CHANGED = 6;
    private String name;
    private Units units;
    private int type;
    private Value v = new Value();
    private ArrayList listeners = new ArrayList();

    public Variable(String name, int type) {
        this(name, type, "");
    }

    public Variable(String name, int type, String units) {
        this(name, type, new Units(units));
    }

    public Variable(String name, int type, Units units) {
        if (type != FUNCTION && type != DEPENDENT && type != PARAMETER) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        this.type = type;
        this.setName(name);
        this.setUnits(units);
    }

    public void addVariableListener(VariableListener listener) {
        this.listeners.add(listener);
    }

    public void removeVariableListener(VariableListener listener) {
        this.listeners.remove(listener);
    }

    public int type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.notifyVariableChanging(NAME_CHANGING, name)) {
            throw new IllegalArgumentException("Cannot change the variable name to " + name);
        }
        this.name = name;
        this.notifyVariableChanged(NAME_CHANGED);
    }

    public Units units() {
        return this.units;
    }

    public void setUnits(Units units) {
        if (!this.notifyVariableChanging(UNITS_CHANGING, units)) {
            throw new IllegalArgumentException("Cannot change the variable units to " + units);
        }
        this.units = units;
        this.notifyVariableChanged(UNITS_CHANGED);
    }

    public abstract double value();

    public void setValue(double value) {
        this.v.set(value);
        if (!this.notifyVariableChanging(VALUE_CHANGING, this.v)) {
            throw new IllegalArgumentException("Cannot change the variable value to " + value);
        }
        this.setVariableValue(value);
        this.notifyVariableChanged(VALUE_CHANGED);
    }

    protected abstract void setVariableValue(double var1);

    boolean notifyVariableChanging(int type, Object change) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            VariableListener l = (VariableListener)this.listeners.get(i);
            if (!(type == NAME_CHANGING ? !l.variableChangingName(this, (String)change) : (type == VALUE_CHANGING ? !l.variableChangingValue(this, ((Value)change).getDouble()) : type == UNITS_CHANGING && !l.variableChangingUnits(this, (Units)change)))) continue;
            return false;
        }
        return true;
    }

    void notifyVariableChanged(int type) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            VariableListener l = (VariableListener)this.listeners.get(i);
            if (type == NAME_CHANGED) {
                l.variableChangedName(this);
                continue;
            }
            if (type == VALUE_CHANGED) {
                l.variableChangedValue(this);
                continue;
            }
            if (type == UNITS_CHANGED) {
                l.variableChangedUnits(this);
                continue;
            }
            if (type != RANGE_CHANGED) continue;
            l.variableChangedRange(this);
        }
    }
}

