/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer;

import hep.aida.ext.IVariableSettings;

public class VariableSettings
implements IVariableSettings {
    private String name;
    private double stepSize;
    private double upperBound;
    private double lowerBound;
    private boolean isFixed;
    private double currentValue;
    private final double stepSizeDef = 1.0;
    private final boolean isFixedDef = false;
    private final double upperBoundDef = Double.POSITIVE_INFINITY;
    private final double lowerBoundDef = Double.NEGATIVE_INFINITY;
    private final double defValue = Double.NaN;

    public VariableSettings(String name) {
        this.reset();
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public double stepSize() {
        return this.stepSize;
    }

    public double upperBound() {
        return this.upperBound;
    }

    public double lowerBound() {
        return this.lowerBound;
    }

    public boolean isBound() {
        return this.upperBound != Double.POSITIVE_INFINITY || this.lowerBound != Double.NEGATIVE_INFINITY;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setStepSize(double step) {
        if (!(step > 0.0)) {
            throw new IllegalArgumentException("Illegal step size " + step + " it has to be positive!");
        }
        this.stepSize = step;
    }

    public void setBounds(double lo, double up) {
        if (up < lo) {
            throw new IllegalArgumentException("Lower bound cannot be less than upper bound : " + lo + " > " + up);
        }
        if (!Double.isNaN(this.value()) && (this.value() < lo || this.value() > up)) {
            throw new IllegalArgumentException("The value " + this.value() + " is outside of the range " + lo + " " + up);
        }
        this.upperBound = up;
        this.lowerBound = lo;
    }

    public void removeBounds() {
        this.upperBound = Double.POSITIVE_INFINITY;
        this.lowerBound = Double.NEGATIVE_INFINITY;
    }

    public void setFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }

    public void reset() {
        this.setStepSize(1.0);
        this.setFixed(false);
        this.setBounds(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.setValue(Double.NaN);
    }

    public double value() {
        return this.currentValue;
    }

    public void setValue(double value) {
        if (value < this.lowerBound() || value > this.upperBound()) {
            throw new IllegalArgumentException("The value " + value + " is outside of the bounds " + this.lowerBound() + " " + this.upperBound());
        }
        this.currentValue = value;
    }
}

