/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtils;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class XYLineAndShapeRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private Boolean linesVisible = null;
    private BooleanList seriesLinesVisible = new BooleanList();
    private boolean defaultLinesVisible = true;
    private Boolean shapesVisible = null;
    private BooleanList seriesShapesVisible = new BooleanList();
    private boolean defaultShapesVisible = true;
    private Boolean shapesFilled = null;
    private BooleanList seriesShapesFilled = new BooleanList();
    private boolean defaultShapesFilled = true;
    private boolean drawOutlines = false;
    private boolean useOutlinePaint = false;

    public int getPassCount() {
        return 2;
    }

    public boolean getItemLineVisible(int series, int item) {
        return this.getSeriesLinesVisible(series);
    }

    public boolean getSeriesLinesVisible(int series) {
        if (this.linesVisible != null) {
            return this.linesVisible;
        }
        Boolean flag = this.seriesLinesVisible.getBoolean(series);
        if (flag != null) {
            return flag;
        }
        return this.defaultLinesVisible;
    }

    public void setLinesVisible(boolean visible) {
        this.setLinesVisible(BooleanUtils.valueOf((boolean)visible));
    }

    public void setLinesVisible(Boolean visible) {
        this.linesVisible = visible;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLinesVisible(int series, boolean visible) {
        this.setSeriesLinesVisible(series, BooleanUtils.valueOf((boolean)visible));
    }

    public void setSeriesLinesVisible(int series, Boolean flag) {
        this.seriesLinesVisible.setBoolean(series, flag);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDefaultLinesVisible() {
        return this.defaultLinesVisible;
    }

    public void setDefaultLinesVisible(boolean flag) {
        this.defaultLinesVisible = flag;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeVisible(int series, int item) {
        return this.getSeriesShapesVisible(series);
    }

    public boolean getSeriesShapesVisible(int series) {
        if (this.shapesVisible != null) {
            return this.shapesVisible;
        }
        Boolean flag = this.seriesShapesVisible.getBoolean(series);
        if (flag != null) {
            return flag;
        }
        return this.defaultShapesVisible;
    }

    public void setShapesVisible(boolean visible) {
        this.setShapesVisible(BooleanUtils.valueOf((boolean)visible));
    }

    public void setShapesVisible(Boolean visible) {
        this.shapesVisible = visible;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesShapesVisible(int series, boolean visible) {
        this.setSeriesShapesVisible(series, BooleanUtils.valueOf((boolean)visible));
    }

    public void setSeriesShapesVisible(int series, Boolean flag) {
        this.seriesShapesVisible.setBoolean(series, flag);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDefaultShapesVisible() {
        return this.defaultShapesVisible;
    }

    public void setDefaultShapesVisible(boolean flag) {
        this.defaultShapesVisible = flag;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeFilled(int series, int item) {
        return this.getSeriesShapesFilled(series);
    }

    public boolean getSeriesShapesFilled(int series) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean flag = this.seriesShapesFilled.getBoolean(series);
        if (flag != null) {
            return flag;
        }
        return this.defaultShapesFilled;
    }

    public void setShapesFilled(boolean filled) {
        this.setShapesFilled(BooleanUtils.valueOf((boolean)filled));
    }

    public void setShapesFilled(Boolean filled) {
        this.shapesFilled = filled;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesShapesFilled(int series, boolean flag) {
        this.setSeriesShapesFilled(series, BooleanUtils.valueOf((boolean)flag));
    }

    public void setSeriesShapesFilled(int series, Boolean flag) {
        this.seriesShapesFilled.setBoolean(series, flag);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(boolean flag) {
        this.defaultShapesFilled = flag;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean flag) {
        this.drawOutlines = flag;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean flag) {
        this.useOutlinePaint = flag;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYItemRendererState state = new XYItemRendererState(info);
        return state;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Number x1n = dataset.getXValue(series, item);
        Number y1n = dataset.getYValue(series, item);
        if (y1n == null || x1n == null) {
            return;
        }
        double x1 = x1n.doubleValue();
        double y1 = y1n.doubleValue();
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (pass == 0) {
            if (this.getItemLineVisible(series, item) && item > 0) {
                Number x0n = dataset.getXValue(series, item - 1);
                Number y0n = dataset.getYValue(series, item - 1);
                if (y0n != null && x0n != null) {
                    double x0 = x0n.doubleValue();
                    double y0 = y0n.doubleValue();
                    double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
                    double transY0 = rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
                    if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) {
                        return;
                    }
                    PlotOrientation orientation = plot.getOrientation();
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        state.workingLine.setLine(transY0, transX0, transY1, transX1);
                    } else if (orientation == PlotOrientation.VERTICAL) {
                        state.workingLine.setLine(transX0, transY0, transX1, transY1);
                    }
                    if (state.workingLine.intersects(dataArea)) {
                        g2.setStroke(this.getItemStroke(series, item));
                        g2.setPaint(this.getItemPaint(series, item));
                        g2.draw(state.workingLine);
                    }
                }
            }
        } else if (pass == 1 && this.getItemShapeVisible(series, item)) {
            Shape shape = this.getItemShape(series, item);
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = this.createTransformedShape(shape, transY1, transX1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = this.createTransformedShape(shape, transX1, transY1);
            }
            if (shape.intersects(dataArea)) {
                if (this.getItemShapeFilled(series, item)) {
                    g2.setPaint(this.getItemPaint(series, item));
                    g2.fill(shape);
                    if (this.getDrawOutlines()) {
                        if (this.getUseOutlinePaint()) {
                            g2.setPaint(this.getItemOutlinePaint(series, item));
                        } else {
                            g2.setPaint(this.getItemPaint(series, item));
                        }
                        g2.draw(shape);
                    }
                } else {
                    if (this.getUseOutlinePaint()) {
                        g2.setPaint(this.getItemOutlinePaint(series, item));
                    } else {
                        g2.setPaint(this.getItemPaint(series, item));
                    }
                    g2.draw(shape);
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer r = (XYLineAndShapeRenderer)obj;
            if (super.equals(obj)) {
                boolean b0 = ObjectUtils.equal((Object)this.linesVisible, (Object)r.linesVisible);
                boolean b1 = ObjectUtils.equal((Object)this.seriesLinesVisible, (Object)r.seriesLinesVisible);
                boolean b2 = this.defaultLinesVisible == r.defaultLinesVisible;
                boolean b3 = ObjectUtils.equal((Object)this.shapesVisible, (Object)r.shapesVisible);
                boolean b4 = ObjectUtils.equal((Object)this.seriesShapesVisible, (Object)r.seriesShapesVisible);
                boolean b5 = this.defaultShapesVisible == r.defaultShapesVisible;
                boolean b6 = ObjectUtils.equal((Object)this.shapesFilled, (Object)r.shapesFilled);
                boolean b7 = ObjectUtils.equal((Object)this.seriesShapesFilled, (Object)r.seriesShapesFilled);
                boolean b8 = this.defaultShapesFilled == r.defaultShapesFilled;
                boolean b9 = this.drawOutlines == r.drawOutlines;
                boolean b10 = this.useOutlinePaint == r.useOutlinePaint;
                return b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8 && b9 && b10;
            }
        }
        return false;
    }
}

