/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.Effect3D;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.ui.RectangleEdge;

public class NumberAxis3D
extends NumberAxis
implements Serializable {
    public NumberAxis3D() {
        this(null);
    }

    public NumberAxis3D(String label) {
        super(label);
        this.setAxisLineVisible(false);
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (!this.isVisible()) {
            AxisState state = new AxisState(cursor);
            List ticks = this.refreshTicks(g2, state, plotArea, dataArea, edge);
            state.setTicks(ticks);
            return state;
        }
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        Effect3D e3D = (Effect3D)((Object)plot.getRenderer());
        double adjustedX = dataArea.getMinX();
        double adjustedY = dataArea.getMinY();
        double adjustedW = dataArea.getWidth() - e3D.getXOffset();
        double adjustedH = dataArea.getHeight() - e3D.getYOffset();
        if (edge == RectangleEdge.LEFT || edge == RectangleEdge.BOTTOM) {
            adjustedY += e3D.getYOffset();
        } else if (edge == RectangleEdge.RIGHT || edge == RectangleEdge.TOP) {
            adjustedX += e3D.getXOffset();
        }
        Rectangle2D.Double adjustedDataArea = new Rectangle2D.Double(adjustedX, adjustedY, adjustedW, adjustedH);
        AxisState info = this.drawTickMarksAndLabels(g2, cursor, plotArea, adjustedDataArea, edge);
        info = this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, info);
        return info;
    }
}

