/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.filechooser;

import com.jcraft.jsch.ChannelSftp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import org.apache.log4j.Logger;

public class RemoteFileSystemView
extends FileSystemView {
    private static Logger logger = Logger.getLogger(RemoteFileSystemView.class.getName());
    private boolean isRemote = false;
    private ChannelSftp c;
    private String FS = System.getProperty("file.separator");

    public RemoteFileSystemView() {
    }

    public RemoteFileSystemView(boolean isRemote) {
        this.isRemote = isRemote;
        if (isRemote) {
            this.FS = "/";
        }
    }

    public RemoteFileSystemView(ChannelSftp c2) {
        this.c = c2;
        if (c2 != null) {
            this.isRemote = true;
            this.FS = "/";
        }
    }

    public File createFileObject(String path) {
        logger.debug("createFileObject");
        File retValue = null;
        if (!this.isRemote) {
            retValue = super.createFileObject(path);
        } else {
            logger.debug("path: " + path);
            retValue = new RemoteFile(path, this.c);
        }
        return retValue;
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        File[] retValue;
        if (!this.isRemote) {
            retValue = super.getFiles(dir, useFileHiding);
        } else {
            logger.debug("getFiles: " + dir.getAbsolutePath());
            RemoteFile rfile = new RemoteFile(dir.getAbsolutePath(), this.c);
            retValue = rfile.listFiles();
        }
        return retValue;
    }

    public File getChild(File parent, String fileName) {
        logger.debug("getChild");
        File retValue = !this.isRemote ? super.getChild(parent, fileName) : new RemoteFile(parent.getAbsolutePath(), fileName, this.c);
        return retValue;
    }

    public File createFileObject(File dir, String filename) {
        logger.debug("createFileObject");
        File retValue = !this.isRemote ? super.createFileObject(dir, filename) : new RemoteFile(dir.getAbsolutePath(), filename, this.c);
        return retValue;
    }

    public Boolean isTraversable(File f) {
        Boolean retValue;
        if (!this.isRemote) {
            retValue = super.isTraversable(f);
        } else {
            RemoteFile rfile = new RemoteFile(f.getAbsolutePath(), this.c);
            retValue = new Boolean(rfile.canRead());
        }
        return retValue;
    }

    public boolean isRoot(File f) {
        boolean retValue;
        logger.debug("isRoot");
        if (!this.isRemote) {
            retValue = super.isRoot(f);
        } else {
            String fs = f.getAbsolutePath();
            retValue = fs.equals("/");
        }
        return retValue;
    }

    public boolean isFloppyDrive(File dir) {
        boolean retValue = !this.isRemote ? super.isFloppyDrive(dir) : false;
        return retValue;
    }

    public boolean isHiddenFile(File f) {
        boolean retValue = !this.isRemote ? super.isHiddenFile(f) : false;
        return retValue;
    }

    public boolean isFileSystemRoot(File dir) {
        logger.debug("isFileSystemRoot");
        boolean retValue = !this.isRemote ? super.isFileSystemRoot(dir) : this.isRoot(dir);
        return retValue;
    }

    public boolean isFileSystem(File f) {
        logger.debug("isFileSystem");
        boolean retValue = !this.isRemote ? super.isFileSystem(f) : true;
        return retValue;
    }

    public boolean isDrive(File dir) {
        logger.debug("isDrive");
        boolean retValue = !this.isRemote ? super.isDrive(dir) : false;
        return retValue;
    }

    public boolean isComputerNode(File dir) {
        boolean retValue = !this.isRemote ? super.isComputerNode(dir) : true;
        return retValue;
    }

    protected File createFileSystemRoot(File f) {
        logger.debug("createFileSystemRoot");
        File retValue = !this.isRemote ? super.createFileSystemRoot(f) : new RemoteFile("/", this.c);
        return retValue;
    }

    public File createNewFolder(File containingDir) throws IOException {
        File file;
        String filestring = containingDir.getAbsolutePath() + this.FS + "NewFolder";
        if (!this.isRemote) {
            file = new File(filestring);
            file.mkdir();
        } else {
            file = new RemoteFile(filestring, this.c);
            file.mkdir();
        }
        return file;
    }

    public File getParentDirectory(File dir) {
        File retValue;
        logger.debug("getParentDirectory");
        if (!this.isRemote) {
            retValue = super.getParentDirectory(dir);
        } else {
            logger.debug("dir: " + dir);
            if (dir == null) {
                retValue = new RemoteFile("/", this.c);
            } else {
                RemoteFile rfile = new RemoteFile(dir.getAbsolutePath(), this.c);
                retValue = rfile.getParentFile();
            }
        }
        return retValue;
    }

    public String getSystemDisplayName(File f) {
        String retValue = !this.isRemote ? super.getSystemDisplayName(f) : f.getName();
        return retValue;
    }

    public Icon getSystemIcon(File f) {
        String folicon = System.getProperty("chase.home") + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + "resource" + System.getProperty("file.separator") + "folder_white.png";
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(folicon));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        ImageIcon ic = new ImageIcon(image);
        logger.debug("got image icon ...");
        Icon retValue = super.getSystemIcon(f);
        if (this.isRemote) {
            retValue = ic;
        }
        return retValue;
    }

    public String getSystemTypeDescription(File f) {
        String retValue = !this.isRemote ? super.getSystemTypeDescription(f) : null;
        return retValue;
    }

    public String toString() {
        String retValue = super.toString();
        return retValue;
    }

    public boolean isParent(File folder, File file) {
        boolean retValue = !this.isRemote ? super.isParent(folder, file) : false;
        return retValue;
    }

    public int hashCode() {
        int retValue = super.hashCode();
        return retValue;
    }

    public File getDefaultDirectory() {
        File retValue;
        logger.debug("getDefaultDirectory");
        if (!this.isRemote) {
            retValue = super.getDefaultDirectory();
        } else {
            String curdir = this.c.pwd();
            logger.debug("curdir: " + curdir);
            retValue = new RemoteFile(curdir, this.c);
        }
        return retValue;
    }

    public File getHomeDirectory() {
        File retValue;
        logger.debug("getHomeDirectory");
        if (!this.isRemote) {
            retValue = super.getHomeDirectory();
        } else {
            String curdir = this.c.pwd();
            logger.debug("curdir: " + curdir);
            retValue = new RemoteFile(curdir, this.c);
        }
        return retValue;
    }

    public File[] getRoots() {
        logger.debug("getRoots");
        File[] retValue = !this.isRemote ? super.getRoots() : new File[]{new RemoteFile("/", this.c)};
        return retValue;
    }
}

