/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.projectcreator;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeNode;
import jp.advancesoft.chase.common.ChooserButton;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeEvent;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeListener;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChanger;
import jp.advancesoft.chase.projectbrowser.projectcreator.SubProjectCreatorPanel;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.hosts.HostList;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class NewProjectCreator
extends InternalFrameChase
implements ProjectStateChanger {
    private static Logger logger = Logger.getLogger(NewProjectCreator.class.getName());
    private ProjectDirBrowserNode parentNode;
    private SubProjectCreatorPanel subpanel;
    private JCheckBox subedit;
    private JTextField name;
    private JTextField path;
    private Vector listeners = new Vector();
    private ProjectDirBrowser dirBrowser;

    public NewProjectCreator(ProjectDirBrowserNode parentNode, ProjectDirBrowser dirBrowser) {
        super("new project", true, true, true, true, new Dimension(500, 280));
        this.parentNode = parentNode;
        this.dirBrowser = dirBrowser;
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder("edit project info"));
        p.setLayout(new BoxLayout(p, 0));
        HostList hostList = HostList.getHostList();
        String baseDir = System.getProperty("user.home") + System.getProperty("file.separator") + "chase_projects";
        for (int i = 0; i < hostList.size(); ++i) {
            HostInfo host = hostList.getHostInfo(i);
            if (!host.getName().equals("localhost")) continue;
            baseDir = host.getProperty("basedir");
        }
        File f = new File(baseDir);
        if (!f.exists() && !f.mkdirs()) {
            logger.error("failed to create " + baseDir);
            this.dispose();
            return;
        }
        this.name = new JTextField(this.getDefaultName(), 10);
        JPanel pname = new JPanel();
        pname.add(this.name);
        pname.setBorder(new TitledBorder("project name"));
        pname.setLayout(new GridLayout(1, 1));
        this.path = new JTextField(baseDir, 30);
        ChooserButton cb = new ChooserButton(0, this.path);
        JPanel ppath = new JPanel();
        ppath.setLayout(new BoxLayout(ppath, 0));
        ppath.add(this.path);
        ppath.add(cb);
        ppath.setBorder(new TitledBorder("base directory"));
        p.add(pname);
        p.add(ppath);
        JPanel ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 1));
        ptmp.add(p);
        this.getContentPane().add(ptmp);
        JPanel psub = new JPanel();
        psub.setBorder(new TitledBorder("initial sub project"));
        psub.setLayout(new BoxLayout(psub, 1));
        this.subedit = new JCheckBox("create initial sub project");
        JPanel psubedit = new JPanel();
        psubedit.setLayout(new BoxLayout(psubedit, 0));
        psub.add(this.subedit);
        this.subpanel = new SubProjectCreatorPanel(this.parentNode, this.dirBrowser);
        psub.add(this.subpanel);
        this.getContentPane().add(psub);
        this.subedit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewProjectCreator.this.subpanel.setEnabled(NewProjectCreator.this.subedit.isSelected());
            }
        });
        this.subedit.setSelected(true);
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new GridLayout(1, 2));
        JButton ok = new JButton("ok");
        JButton cancel = new JButton("cancel");
        pbtn.add(ok);
        pbtn.add(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewProjectCreator.this.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewProjectCreator.this.manipulateProjectState();
                NewProjectCreator.this.dispose();
            }
        });
        this.getContentPane().add(pbtn);
    }

    public void addProjectStateChangeListener(ProjectStateChangeListener listener) {
        this.listeners.addElement(listener);
    }

    public void manipulateProjectState() {
        String projdir = this.path.getText() + System.getProperty("file.separator") + this.name.getText();
        File f = new File(projdir);
        if (!f.exists() && !f.mkdirs()) {
            logger.error("failed to create " + projdir);
            this.dispose();
            return;
        }
        Element element = new Element("project");
        element.setAttribute(new Attribute("display", "true"));
        element.setAttribute(new Attribute("hassub", "true"));
        element.setAttribute(new Attribute("subident", "subproject"));
        Element elemname = new Element("name");
        elemname.setText(this.name.getText());
        element.addContent(elemname);
        Element elemdate = new Element("date");
        Calendar calendar = Calendar.getInstance();
        elemdate.setText(calendar.getTime().toString());
        element.addContent(elemdate);
        Element elemtype = new Element("type");
        elemtype.setText("chase project");
        element.addContent(elemtype);
        Element elemdir = new Element("directory");
        elemdir.setText(this.path.getText() + System.getProperty("file.separator") + this.name.getText());
        element.addContent(elemdir);
        ProjectDirBrowserNode nd = new ProjectDirBrowserNode(element, this.dirBrowser);
        nd.addProjectDirBrowserNodeChangeListener(this.dirBrowser);
        this.dirBrowser.addObject(nd);
        if (this.subedit.isSelected()) {
            this.subpanel.setParentNode(nd);
            this.subpanel.createElement();
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProjectStateChangeListener listener = (ProjectStateChangeListener)this.listeners.elementAt(i);
            listener.projectStateChanged(new ProjectStateChangeEvent(this, this.name.getText()));
        }
    }

    private String getDefaultName() {
        boolean proj = false;
        Enumeration<TreeNode> enumeration = this.parentNode.children();
        String defaultName = "project";
        Vector<String> vec = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String name;
            ProjectDirBrowserNode node = (ProjectDirBrowserNode)enumeration.nextElement();
            ProjectInfo info = node.getProjectInfo();
            if (info.getInfoType() != 1 || !(name = info.getProjectName().toLowerCase()).startsWith(defaultName)) continue;
            vec.addElement(name);
        }
        if (vec.size() == 0) {
            return defaultName;
        }
        return NewProjectCreator.getNonDupliString(defaultName, vec);
    }

    protected static String getNonDupliString(String string, Vector comp) {
        boolean foundDupli;
        String compstring = string;
        int max = 500;
        int co = 0;
        do {
            foundDupli = false;
            for (int i = 0; i < comp.size(); ++i) {
                if (!compstring.equals((String)comp.elementAt(i))) continue;
                foundDupli = true;
                compstring = string + String.valueOf(co);
                ++co;
            }
        } while (foundDupli && co < max);
        return compstring;
    }
}

