/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.fileinfo;

import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.advancesoft.chase.common.RegExpedString;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfo;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoEvent;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoListener;

class FileInfoEditor
extends JPanel
implements FileInfoListener {
    private FileInfo info;
    private JTextField textfield;
    private File defaultParent;

    protected FileInfoEditor(FileInfo info, File defaultParent) {
        this.info = info;
        this.defaultParent = defaultParent;
        this.setLayout(new BoxLayout(this, 1));
        RegExpedString res = info.getIdentifier();
        if (!res.hasRegExp()) {
            this.setBorder(new TitledBorder(res.getValue()));
        } else {
            this.setBorder(new TitledBorder(res.getReplaceString()));
        }
        this.init();
    }

    private void init() {
        String[] names = this.info.getNames();
        for (int i = 0; i < names.length; ++i) {
            this.textfield = new JTextField(names[i]);
            this.textfield.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent ce) {
                    FileInfoEditor.this.update();
                }
            });
            File path = this.info.getPath();
            if (path != null) {
                if (path.isAbsolute()) {
                    this.textfield.setToolTipText(path.getPath());
                } else {
                    try {
                        this.textfield.setToolTipText(new File(this.defaultParent.getAbsolutePath() + System.getProperty("file.separator") + path).getCanonicalPath());
                    }
                    catch (IOException ioe) {
                        this.textfield.setToolTipText(path.getPath());
                    }
                }
            }
            this.add(this.textfield);
        }
    }

    private void update() {
        this.info.removeFileInfoChangeListener(this);
        this.info.setName(this.textfield.getText());
        this.info.addFileInfoChangeListener(this);
    }

    protected FileInfo getFileInfo() {
        return this.info;
    }

    public void fileInfoChanged(FileInfoEvent fie) {
        this.textfield.setText(fie.getFileInfo().getName());
    }
}

