/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.phase.AtomConfigPanel;
import jp.advancesoft.chase.phase.ChoicePanelPhase;
import jp.advancesoft.chase.phase.ElementList;
import jp.advancesoft.chase.phase.GUIBootButton;
import jp.advancesoft.chase.phase.PhaseInputItems;
import jp.advancesoft.chase.phase.StructuralEvolution;
import jp.advancesoft.chase.phase.SymmetryDetails;
import org.apache.log4j.Logger;

class StructurePanel
extends PhaseInputItems {
    private static Logger logger = Logger.getLogger(StructurePanel.class.getName());

    protected StructurePanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    void createGUI() {
        this.add(this.createStructurePanel());
    }

    private JPanel createStructurePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setPreferredSize(new Dimension(500, 500));
        p.add(this.upperHalf());
        p.add(new AtomConfigPanel(this.inputInterface, new AtomCoords()));
        p.add(Box.createVerticalStrut(5));
        return p;
    }

    private JPanel upperHalf() {
        JPanel p_str = new JPanel();
        p_str.setLayout(new GridLayout(2, 3, 1, 1));
        String struc = "structure.";
        String[] ctspecs = new String[]{struc + "unit_cell_type"};
        String[] ctchoice = new String[]{this.NO_SELECTION, "Primitive", "Bravais"};
        ChoicePanelPhase ct = new ChoicePanelPhase(ctspecs, this.inputInterface, "unit cell type", ctchoice, this);
        String[] magspecs = new String[]{struc + "magnetic_state"};
        String[] magchoice = new String[]{this.NO_SELECTION, "para", "antiferro", "ferro"};
        Vector<String[]> magdupli = new Vector<String[]>();
        magdupli.addElement(new String[]{"2", "af"});
        ChoicePanelPhase mag = new ChoicePanelPhase(magspecs, this.inputInterface, "magnetic state", magchoice, magdupli, this);
        p_str.add(ct);
        p_str.add(mag);
        JPanel p_b_tspace = new JPanel();
        p_b_tspace.setLayout(new BorderLayout());
        p_b_tspace.setBorder(new TitledBorder("Symmetry"));
        GUIBootButton btntspace = new GUIBootButton("edit symmetry ...", this.inputInterface, SymmetryDetails.class, (ActionListener)this);
        p_b_tspace.add((Component)btntspace, "Center");
        p_str.add(p_b_tspace);
        JPanel p_b_element = new JPanel();
        p_b_element.setLayout(new BorderLayout());
        p_b_element.setBorder(new TitledBorder("Element list"));
        GUIBootButton btnelm = new GUIBootButton("edit element list ...", this.inputInterface, ElementList.class, (ActionListener)this);
        p_b_element.add((Component)btnelm, "Center");
        p_str.add(p_b_element);
        JPanel p_b_motion = new JPanel();
        p_b_motion.setLayout(new BorderLayout());
        p_b_motion.setBorder(new TitledBorder("Structural evolution"));
        GUIBootButton btnstev = new GUIBootButton("edit structural evolution ...", this.inputInterface, StructuralEvolution.class, (ActionListener)this);
        p_b_motion.add((Component)btnstev, "Center");
        p_str.add(p_b_motion);
        return p_str;
    }
}

